;**********************************************************************
;                                                                     *
;    Filename:	    5351OSC1.asm                                      *
; Ref file  Q 9833SG.asm / 5351Test.asm    
;    Date:  2023.02.163     /2023.05.19Rev0;8pF 
;           /Rev1 2023.10.14 SMD25MHzg␳(RA2)ǉ /Ra2=Open6pF(Hp)   
;           /Rev2 2025.12.31 RA3=L ɂā@Su5351oOFF                                      *
;    File Version:                                    *
;                                                                     *
;    Author:                                                          *
;    Company:                                                         *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files Required: P16F883.INC                                      *
;         NbN	NbN 8MHzz                            *
;**********************************************************************
;;    Notes:                                                           *

;
;sATCFidENX^E̔z͏ȗj
;		( H:[qopen(LED̐ڑ̂݁j  L:[q2.4kGRDɗƂ)
;	()̓sԍ

;	RC7(18)			LCD RS			    
;	RC6(17)			LCD E		
;	RC5(16)				
;	RC4(15)			SDA(I2C)
;	RC3(14)			SCL(I2C)		
;	RC2(13)				
;	RC1(12)					
;	RC0(11)				
      
;	RA7-OSC1(8)		
;	RA6-OSC2(7)			
;	RA4(6)					
;	RA3(5)			 Spare		
;	RA2(4)			 Spare		
;	RA1(3)			 Hetodyne Upper/ Lower
;	RA0(2)			GNDŁ@IF offset
			
;	RB7(28)			;if RB7,0=L, then Encoder non-click4{			    
;	RB6(27)				
;	RB5(26)			ENC-A	
;	RB4(25)			ENC-B
;	RB3(24)			LCD DB4	SW-1; Spare
;	RB2(23)			LCD DB5	SW-3; Mem
;	RB1(22)			LCD DB6 =	SW-2; Band; 
;	RB0(21)			LCD DB7 	SW-1; Step	 /DefaultReset during Power ON           
;**********************************************************************
;********EEPROMZ@** 00,01___,02,03,04,05,06,07___,___08,___09,0a,0b,
;********************ROM1,Nband,b0,b1,b2,aa,dd,cn_bb,Ifre0,Ifre1,Ifre2,
;*Band SWiRB1j ȂAdƁAiFg(100HzP)o^[hƂȂ

	list		p=16f883	; list directive to define processor
	#include	<p16f883.inc>	; processor specific variable definitions

	errorlevel  -302              ; suppress message 302 from list file

; '__CONFIG' directive is used to embed configuration data within .asm file.
; The labels following the directive are located in the respective .inc file.
; See respective data sheet for additional information on configuration word.

	__CONFIG    _CONFIG1, _LVP_OFF & _FCMEN_ON & _IESO_OFF & _BOR_OFF & _CPD_OFF & _CP_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
	__CONFIG    _CONFIG2, _WRT_OFF & _BOR21V

#define		RS   	PORTC,7		;LCD RS
#define		E   	PORTC,6		;LCD E
#define		Trigo  	PORTC,5		;Trigger Out
#define		Mult  	PORTA,2		;ICS570 ON (x6)
;***** VARIABLE DEFINITIONS
val0		EQU	H'70'		; ϊliRQrbgj	
val1		EQU	H'71'	
val2		EQU	0x72		; ϊliRQrbgj				;
val3		EQU	0x73
k0		EQU	0x74
k1		EQU	0x75
k2		EQU	H'76'	;;
k3		EQU	H'77'	;
Regnum		EQU	H'78' ;	;I2C All bank accesses	
dat_Si		EQU	H'79'	;I2C All bank accesses
VALUE		EQU	H'7A'	;Bank0-4  during Save
scn			EQU	H'7B'	;Bank0-4  during Save
ADDR		EQU	H'7C'	;Bank0-4  during Save
w_temp		EQU	0x7D		; variable used for context saving
status_temp	EQU	0x7E		; variable used for context saving
pclath_temp	EQU	0x7F		; variable used for context saving
;   --------------- adress 20&H  
zz0		EQU	0x20	;ϐ
zz1		EQU	0x21	;
zz2		EQU	0x22	;@
zz3		EQU	0x23	;
N		EQU	0x24	;|Zϐ
x0			EQU	0x25	;
x1			EQU	0x26
x2			EQU	0x27
x3			EQU	0x28
y0			EQU	0x29	  	;
y1			EQU	0x2a
y2			EQU	0x2b
y3			EQU	0x2c
Nband		EQU	0x2d	;Nband 	;0`14
wait_cn		EQU	0x2E	
wait_cn2	EQU	0x2F
;   -------------- adress 30&H
dec0		EQU	0x30	; 10ii[ꏊiPOoCgj
dec1        EQU 0x31    	
dec2		EQU	0x32		;0.1kHz
dec3		EQU	0x33		;1kHz
dec4		EQU	0x34
dec5		EQU	0x35
dec6		EQU	0x36
dec7		EQU	0x37
dec8		EQU	0x38
dec9		EQU	0x39
cs			EQU	0x3A
d8			EQU	0x3B
d4			EQU	0x3C
cL			EQU	0x3D	;LCDpJE^[ 
ct			EQU	0x3E
cn			EQU	0x3F	
;    ------------- adress 40&H
ct0		EQU	0x40		
SiOFF		EQU	0x41	;2025.12.31 RB6 ̗l;Si5351 ON/OFF
;	EQU	0x42	
val_m	EQU	0x43		; ꎞ]i[ꏊiTu[`Ŏgpj
new45		EQU	H'44'	;RB4,5߰Ă̌ݒl;
old45		EQU	H'45'	;;RB4,5߰Ẳߋl Encoder
xor45bit	EQU	H'46'	;;RB4,5߰Ẳߋl Encoder 2bit shift
poi			EQU	H'47'
Reg_A		EQU	H'48'	;PortA 0,1̕ωmWX^
Rb30		EQU	H'49'	;Rb3-0 ̕ۑWX^
vfc			EQU	H'4a'	;vfo Change;if vfc.0=1, then Si5351݁A\ւ̕
dsp1		EQU	H'4b'	;step\@ő包
dsp2		EQU	H'4c'
dsp3		EQU	H'4d'
dsp4		EQU	H'4e'	;step\@H(48),k(6b),M(4d)
N_step		EQU	H'4F'	;N_step =0(25H) ,1(50Hz), 2(500Hz) ,3(10kHz), 4(100kHz), 5(1MHz:Band11(dd=6)ȏ̂)
;    ------------- adress 50&H		
Bnum0		EQU	0x50	;LCD2sځ@BandNumber
Bnum1		EQU	0x51	;LCD2sځ@BandNumber
BFre1		EQU	0x52	;LCD2s g BFrem1`BFrem8 ͘Azû
BFre2		EQU	0x53	;
BFre3		EQU	0x54	;
BFre4		EQU	0x55	;

BFre5		EQU	0x56	;LCD2s g
BFre6		EQU	0x57	;@
BFre7		EQU	0x58	;
BFre8		EQU	H'59'	;
IFset		EQU	H'5a'	;if IFset.0=1, IFo^[h dRB1-SW ON
Ifre0		EQU	0x5b		;IFgi100HzPʁj if IF=64.0MHz, 64.000.0=H'9 C4 00'5b
Ifre1		EQU	0x5c
Ifre2		EQU	0x5d


;    ------------- adress 70&H	
;    ----Bank1--------- adress A0&H	
P1N_0		EQU	H'A0'	;MSNx_P1[7:0]	;MSNx_P1[17:0]=128 x a +Floor(128x(b/c))-512 
P1N_1		EQU	H'A1'	;MSNx_P1[15:8]
P1N_2		EQU	H'A2'	;MSNx_P1[17:16]

P2N_0		EQU	H'A3'	;MSNx_P2[7:0]	;MSNx_P2[19:0]= 128 x b - c x Floor(128x(b/c)
P2N_1		EQU	H'A4'	;MSNx_P2[15:8]
P2N_2		EQU	H'A5'	;MSNx_P2[19:16]
P2N_3		EQU	H'A6'	;vZɎg

P3N_0		EQU	H'A7'	;MSNx_P3[7:0]	;MSNx_P3[19:0]= c /
P3N_1		EQU	H'A8'	;MSNx_P3[15:8]			;/Always Fixed  c =250,000 =H'3 d0 90'	
P3N_2		EQU	H'A9'	;MSNx_P3[19:16]

P1x_0		EQU	H'Aa'	;MSx_P1[7:0]	;MSx_P1[17:0]= 128 xd + Floor (128 x (e/f))-512	 
P1x_1		EQU	H'Ab'	;MSx_P1[15:8]			;//, e=0, f=1
P1x_2		EQU	H'Ac'	;MSx_P1[17:16]

P2x_0		EQU	H'Ad'	;MSx_P2[7:0]	;MSx_P2=0
P2x_1		EQU	H'Ae'	;MSx_P2[15:8]
P2x_2		EQU	H'Af'	;MSx_P2[19:16]

P3x_0		EQU	H'B0'	;MSx_P3[7:0]	;MSx_P3=1
P3x_1		EQU	H'B1'	;MSx_P3[15:8]
P3x_2		EQU	H'B2'	;MSx_P3[19:16]

Fbc			EQU	H'Cb'	;=Floor(128x (b/c))
Fbc1		EQU	H'Cc'	;Fbc1=Fbc
	;-***
ROM1		EQU	H'D0';must be 0xD08/  if EEPRPM save, ROM1=D'1'
N2_bnd		EQU	H'D1'
b0			EQU	H'D2'
b1			EQU	H'D3'
b2			EQU	H'D4'
aa			EQU	H'D5'
dd			EQU	H'D6'
cn_bb		EQU	H'D7'	;bbŹ@vZB@step250,000B
N2_step		EQU	H'D8'	;N_step Bank1ɂu
cn_bbt		EQU	H'D9'	;cn_bbt ̈ꎟn
step0		EQU	H'Da'
step1		EQU	H'Db'
step2		EQU	H'Dc'
Carover		EQU	H'Dd'	;step vZ@,Add ,Sub ̌JオAFlag
Rg16		EQU	H'De'	;;Register 16̓df[^@	H'4C'=2mA/ H'4d'=4mA/ H'4e'=6mA,/ H'4F'=8mA
;**********************************************************************
	ORG     0x000             ; processor reset vector

 	goto    start              ; go to beginning of program

	ORG     0x004             ; interrupt vector location
isr		;;荞ݏ-routine
i_rb0	movwf	w_temp		;W@File w_tempւ̕ۑ
		swapf	STATUS,w          ; move status register into W register
		movwf	status_temp	;status@File@̕ۑ
		movf	PCLATH,w	  ; move pclath register into w register
		movwf	pclath_temp	  ; save off contents of PCLATH register
		bcf		INTCON,GIE

	bcf		STATUS,RP0	;oN0		
	;=========== ȉEncoderu
isr1	movf	PORTB,0  ;	ȉ@g	
		andlw	B'00110000'	
		movwf	new45

		call	wt40u	;40 usec҂.ݺނ̓,ݸޖh~		
		movf	PORTB,0		
		andlw	B'00110000'	;masking othrt than RB4-5
		subwf	new45,0
		btfss	STATUS,Z
		goto	isr1

		movf	new45,0
		subwf	old45,0
		btfsc	STATUS,Z
		goto	pop1
		movf	new45,0
		xorwf	xor45bit,1

isr3	btfsc	PORTB,7
		goto	Enc_1
		goto	Enc_4
		;--------------	ȉ@Encoder x1{, x4{ ̏	
issub	call	sub_v		;b=b-step
		goto	pop
isadd	call 	add_v		;b=b+step
		goto	pop
	;===========
pop		bsf		vfc,0		;vfo change record, vfc=1
pop1	movf	PORTB,0	
		andlw	B'00110000'	
		movwf	old45
		movwf	xor45bit
		bcf		STATUS,C  ;Old45bit 2bit shift up
		rlf		xor45bit,1
		bcf		STATUS,C  ;
		rlf		xor45bit,1

pop2	movf	pclath_temp,w	  ; retrieve copy of PCLATH register
		movwf	PCLATH		  ; restore pre-isr PCLATH register contents
		swapf   status_temp,w     ; retrieve copy of STATUS register
		movwf	STATUS	
		swapf	w_temp,f	;W@File@̖߂
		swapf	w_temp,w
		bcf		INTCON,0	;RBIF;PORTB Change(tOj̃Zbg
		bcf		INTCON,2	;intcon-TMR0IF(tOj̃Zbg		
		bsf		INTCON,GIE 		; Enable INTs.
		retfie
;-----------
IF_data		movlw	H'C0'	;;IFgi100HzPʁj 12.0MHz=10.000.0=H'1 d4 C0'
			movwf	Ifre0
			movlw	H'd4'
			movwf	Ifre1
			movlw	H'01'
			movwf	Ifre2
			return
;=======================
tab_dp	addwf	PCL,1  	;f[^7bit=1ƂBAhXf[^͂̂܂

		retlw	dsp1	;poi=0	u4]; //LCDaddress=H'C0'
		retlw	dsp2	;poi=1	u0v	
		retlw	dsp3	;poi=2	u0v		 
		retlw	dsp4	;poi=3	ukv	
		retlw	H'a0'	;poi=4	u_v; //LCDaddress=H'C4'
		retlw	dec1	;poi=5		
		retlw	dec2	;poi=6	
		retlw	dec3	;poi=7	
		retlw	dec4	;poi=8
		retlw	dec5	;poi=9	
		retlw	H'ac'	;poi=10	u,v
		retlw	dec6	;poi=11	
		retlw	dec7	;poi=12		 
		retlw	dec8	;poi=13	
		retlw	H'ac'	;poi=14	u,v 	
		retlw	dec9	;poi=15	

;   	ȉ2s
		retlw	Bnum0		;poi=16	u1]; //LCDaddress=H'C0'
		retlw	Bnum1		;poi=17 u3v
		retlw	H'a0'		;poi=18	u_v;		
		retlw	H'a0'		;poi=19	u_v;		
		retlw	BFre1		;poi=20	u0v; //LCDaddress=H'C4'
		retlw	BFre2		;poi=21 u8v
		retlw	BFre3		;poi=22	u5v
		retlw	H'ae'		;poi=23	u.v
		retlw	BFre4		;poi=24	u0v
		retlw	H'ad'		;poi=25	u-_v
		retlw	BFre5		;poi=26	u1v//LCDaddress=H'CA'
		retlw	BFre6		;poi=27	u6v;
		retlw	BFre7		;poi=28 u0v
		retlw	H'ae'		;poi=29	u.v	
		retlw	BFre8		;poi=30 u0v 
		retlw	H'cd'		;poi=31 uMv  
	
B_dsp	addwf	PCL,1  	;		;Poi=W=Nband x8// 0=< Nband@<=15
		retlw	D'10'		;Nband=0 lower ;LCD2sڕ\̃oh
		retlw	D'19'		;Nband=0 upper
		retlw	D'13'		;Nband=1 lower
		retlw	D'25'		;Nband=1 upper
		retlw	D'20'		;Nband=2 lower
		retlw	D'37'		;Nband=2 upper
		retlw	D'27'		;Nband=3 lower
		retlw	D'50'		;Nband=3 upper
		retlw	D'40'		;Nband=4 lower
		retlw	D'75'		;Nband=4 upper
		retlw	D'54'		;Nband=5 lower
		retlw	D'100'		;Nband=5 upper
		retlw	D'80'		;Nband=6 lower
		retlw	D'150'		;Nband=6 upper
		retlw	D'105'		;Nband=7 lower
		retlw	D'200'		;Nband=7 upper ;܂20.0MHz̕\@1/10
		retlw	D'16'		;Nband=8 lower	;Nband.3=1 16MHz̕\ x1{
		retlw	D'30'		;Nband=8 upper
		retlw	D'21'		;Nband=9 lower
		retlw	D'40'		;Nband=9 upper
		retlw	D'32'		;Nband=10 lower
		retlw	D'60'		;Nband=10 upper 
		retlw	D'42'		;Nband=11 lower
		retlw	D'80'		;Nband=11 upper
		retlw	D'63'		;Nband=12 lower
		retlw	D'120'		;Nband=12 upper 
		retlw	D'85'		;Nband=13 lower
		retlw	D'160'		;Nband=13 upper 
		retlw	D'130'		;Nband=14 lower
		retlw	D'240'		;Nband=14 upper

;----------------------------------------------------------------------------
start 	bsf  	STATUS,RP0	;oN1		
		movlw	B'01110100'	;OSC=8MHz
		movwf	OSCCON
		bcf  	STATUS,RP0	;oN0

		movlw	D'255'
		movwf	wait_cn
		call	wait_ms

		bsf  	STATUS,RP0	;oN1
		movlw	B'00010100'	;RBvAbv;; RB0JEg; IntClk;prescaler TMR0 1/32 set ;
		movwf	OPTION_REG
		bcf  	STATUS,RP0	;oN0	

	;;port set
		bsf  	STATUS,RP0	;oN3
		bsf  	STATUS,RP1	;oN3
		movlw	B'00000000'	;pinset( All=Digital) 
		movwf	ANSEL

		movlw	B'00000000'	;pinset(RB5`RB0=Digital) 
		movwf	ANSELH
		bcf  	STATUS,RP0	;oN0
		bcf  	STATUS,RP1	;oN0


		bsf  	STATUS,RP0	;oN1
		movlw	B'10010000'	;bit7=1=RightJustify;resultE, bit5=0=Vss_pin, bit4=1=Vref+pin //
		movwf	ADCON1

		movlw	B'00001000'			;bit3=PORTB chage Interrupt, RBIE=1 enable
		movwf	INTCON

		movlw	B'00110000'			;RB4, Change Interrupt, 
		movwf	IOCB

		movlw	B'11111111'		;RB7`0 Pull up;Default, 
		movwf	WPUB

		bsf		STATUS,RP0		;oN1
		movlw	B'11111111'		; All input
		movwf	TRISA
		movlw	B'11111111'		;Rb=All IN 
		movwf	TRISB
		movlw	B'00011000'		;Rc3,4=In for I2C ,Others=OUT 
		movwf	TRISC
		bcf		STATUS,RP0	;oN0
		clrf	PORTA
		clrf	PORTB
		clrf	PORTC
	
;-----------------
I2C_init 	;RC3 &RC4 I2C  setting
		movlw	B'00101000'	;bit5=SSPEN=1=I2C_Enable, 
		movwf	SSPCON		;bit3-0=1000I2C Master modeclock = FOSC / (4 * (SSPADD+1)) 	
		
		bsf		STATUS,RP0 ;Bank1
	;	movlw	B'10000000'	;bit7=1=SMP=100kHz mode x䖳
		movlw	B'00000000'	;bit7=1=SMP=100kHz mode x
		movwf	SSPSTAT		;bit0=BF=0=Data transmit complete, bit2=1=Transmit is in progress

		movlw	D'19'	;<6:0> FOSC / (4 * (SSPADD+1))=8MHz/(4 x 20)=100kHz
	;	movlw	D'39'	;<6:0> FOSC / (4 * (SSPADD+1))=8MHz/(4 x 40)=50kHz
		movwf	SSPADD
		bcf		STATUS,RP0	;Bank0
	;	call	LCD_Ini	;LCD AQM0802 ̏
;-----------------
		bcf		STATUS,RP0 ;Bank0
		movlw	D'255'
		movwf	wait_cn
		call	wait_ms

start2	bcf		STATUS,RP0 ;Bank0
		clrf	vfc
		call	writb
		call	init_lcd ;LCD

		movlw	H'00'	;Step=50Hz
		movwf	N_step
	bsf		STATUS,RP0	;bank1
		movwf	N2_step	
	bcf		STATUS,RP0	;bank0

 		call	readb
		clrf	IFset
		btfsc	PORTB,1	;/IFset during Power ON (Band SW)
		goto	s23
		bsf		IFset,0
	;========== IF ݒJump
		btfss	IFset,0	;if IFset.0=1, IF setting mode
		goto	s22
	bsf		PCLATH,3	;̈GPage1 ւ̐ؑ
		goto	IF_start	;IF setting 
	;==========
s22		call	wt4ms	;prevent chattering
		btfss	PORTB,1	;
		goto	s22

s23		btfsc	PORTB,0	;/Default@Reset during Power ON (Step SW)
		goto	s28
s25		call	wt4ms	;prevent chattering
		btfss	PORTB,0
		goto	s25
		goto	start3

s28		movlw	D'1'
		movwf	cn_bbt
		movwf	cn_bb

		call	load_m	;Loading  ;ROM1,N2_bnd, b0,b1,b2, aa,dd,cn_bb,N2_step 9Aaddress//org x800Ԓn
	bsf		STATUS,RP0	;bank1
		movlw	D'1'	;if ROM1=D'1' , then Memory OK
		subwf	ROM1,0		;if EEPRPM save, ROM1=D'1'
	bcf		STATUS,RP0	;bank0
		btfsc	STATUS,Z	;if ROM1 =1, then start4
		goto	start4
		goto	start3
			;---------
start3	bsf		STATUS,RP0	;bank1 //EEPROMݒ@Nband=7, IF=12.0MHz@
		movlw	B'00000001'	
		movwf	ROM1 ;ROM1=1
	bcf		STATUS,RP0	;bank0
		movlw 	D'7'	;Nband=7//setting a, b, cn_bb
		movwf	Nband
	bsf		STATUS,RP0	;bank1
		movwf	N2_bnd
	bcf		STATUS,RP0	;bank0	
		call	Bnd_set		; Band setting 

	movlw	H'00'	;Step=25Hz
		movwf	N_step
	bsf		STATUS,RP0	;bank1
		movwf	N2_step	
	bcf		STATUS,RP0	;bank0
	
		call 	sav_ini		; ̏EEPROMւ save

		call	IF_data ;default IF=12.000.0MHz
		call	sav_IF	;
		goto	start4

start4	nop;------Si5351 Register ݁@-//Si5351 start //Refer to P.19 of Si5351-B.pdf ----------
	bsf		STATUS,RP0	;bank1
		movf	N2_step,0
	bcf		STATUS,RP0	;bank0	
		movwf	N_step
	bsf		STATUS,RP0	;bank1
;========== MSx_P1 & MSNx_P2 & MSNx_P3set@to Register42-49==============
		call	MSx1		;/ݒvZ
			;MSx_P1[17:0]= 128 xd + Floor (128 x (e/f))-512	 //, e=0, f=1
;==== MSN3CalA@MSN1Cal, MSN2Cal to Register26, 27, 28, 29, 30, 31, 32, 33==============
		call	MSN3Cal		;MSNx_P3[19:0]= c //Always Fixed  c =250,000 =H'3 d0 90'
	;	nop	
		call	MSN1Cal		;MSNx_P1[17:0]=128 x a +Floor(128x(b/c))-512 EEE@
	;	nop
		call	MSN2Cal		;MSNx_P2[19:0]= 128 x b - c x Floor(128x(b/c)@@EEEA			
;========== 

;------Si5351 Register ݁@-//Si5351 start //Refer to P.19 of Si5351-B.pdf ----------
	bsf		STATUS,RP0	;bank1   //Si5351 start //Refer to P.19 of Si5351-B.pdf 
		movlw	D'3'	;Register 3
		movwf	Regnum
		movlw	H'FF'	;Register3	Data=H'FE' //bit0=0  only CLK0 enable Output
		movwf	dat_Si	
		call	Si53_load

		movlw	D'16'	;Register 16
		movwf	Regnum
		movlw	H'80'	;Register16	Data=H'4F' //if bit8=1,CLK0 OutputDown. if bit7=1, MultiSynth Intger;
		movwf	dat_Si				;=4 ̂Ƃ́Abit6=1 must
		call	Si53_load

		movlw	D'17'	;Register 17
		movwf	Regnum
		movlw	H'80'	;CLK1 power down' //
		movwf	dat_Si	
		call	Si53_load

		movlw	D'18'	;Register 18
		movwf	Regnum
		movlw	H'80'	;CLK2 power down' //
		movwf	dat_Si	
		call	Si53_load

			;Register 2//Set interruput mask /Si5351Ał́@svH
		;Manualł́AɁ@Reg.15-92 149-170 ̏
	;MSNx_P1, P2, P3
		call	MSN_Reg
	;MSx_P1, P2, P3
		call	MSx1_Reg

	;=============o͓d@Register16 2mA, 4mA, 6mA, 8mA̕ύX=============
	;; MSNx ,MSx @Power -up
	bsf		STATUS,RP0	;bank1 
		movlw	D'16'	;Register 16
		movwf	Regnum

		movlw	H'4C'	;Registe16   oo=Out;2mA 
 	;	movlw	H'4d'	;Registe16   oo=Out;4mA 
 	;	movlw	H'4e'	;Registe16   oo=Out;6mA 
	;	movlw	H'4F'	;Register16	 oo=Out;8mA     Data=H'4F' //if bit8=0,CLK0 OutputPowered. if bit7=1, MultiSynth Intger;
		movwf	Rg16
		movwf	dat_Si				;=4 ̂Ƃ́Abit6=1 must  11=Out;8mA
		call	Si53_load

  ;=======================RfTRegister@183@6pF, 8pF,10pF ̕ύX=============
		movlw	D'183'	;Register 183
		movwf	Regnum	;;Bits 5:0 should be written to 010010b(AN619)
		movlw	B'01010010'		;	B'01010010'	;Crystal Capacity 6pFHW[͂B
	;	movlw	B'10010010'		;	B'10010010'	;Crystal Capacity 8pF
	;	movlw	B'11010010'		;	B'11010010'	;Crystal Capacity 10pF
		btfsc	PORTA,2		;if PORTA=H, then Crystal Capacity 6pF
		goto 	sta42

		movlw	B'11010010'		;	B'11010010'	;Crystal Capacity 10pF/Default
sta42	movwf	dat_Si		
		call	Si53_load
 ;=======================RfTׁ@6pF, 8pF,10pF ̕ύX ܂=============

		movlw	D'177'	;Register 177
		movwf	Regnum
		movlw	H'AC'	;Register177	Data=H'A0'// PLLA Reset(bit5) and PLLB Reset(bit7)
		movwf	dat_Si	
		call	Si53_load
	
		movlw	D'3'	;Register 3
		movwf	Regnum
		movlw	H'FE'	;Register3	Data=H'FE' //bit0=0  only CLK0 enable Output
		movwf	dat_Si	
		call	Si53_load
				;uI_start  I_adres@ˁ@I_ack@	I_register data	@ˁ@I_ack ˁ@I_data@ˁ@I_ack@ I_stopv
	;--------------------
	bcf		STATUS,RP0	;bank0	

start5	call	stp_set		;step N_step=0(25Hz)
		call	BndN		;LCD 2sڕ\

		call	load_IF	;
		movlw	H'FF'
		subwf	Ifre2,0
		btfss	STATUS,Z
		goto	S_end
		call	IF_data ;default IF=12.000.0MHz

S_end	movlw	B'00001000'			;GIE=0 disable, INTE(RB4-7 Port Change)=1 enable
		movwf	INTCON	; 

		call	putfre
		call	dp_Fre	;	;LCDg@1s5`16@12\

		movf	PORTA,0
		andlw	B'00000011'	;PORTA.0 ,1 ̂ݎc
		movwf 	Reg_A	;Hetrodyne ON/Off?
		clrf	vfc
		bsf		vfc,0

		movlw	B'01000000'		;2025.12.31 
		movwf	SiOFF	;2025.12.31 RB6 ̗l, Si5351 ON-OFF

		bsf		INTCON,7	;荞݊Jn
		nop
;++================ @烁C ===========================
main	movlw	B'10001000'			;bit3=PORTB chage Interrupt, RBIE=1 enable
		movwf	INTCON

		movf	PORTA,0
		andlw	B'00000011'	;PORTA.0 ,1 ̂ݎc
		subwf	Reg_A,0
		btfsc	STATUS,Z	;if PORTA.0, 1 ωȂ΁@skip
		goto	mn5	
			;-- Htrodyne\
		bsf		vfc,0
		movf	PORTA,0
		andlw	B'00000011'	;PORTA.0 ,1 ̂ݎc
		movwf	Reg_A	

mn5		nop	;///2025.12.31 RB6ɂ Si5351 OFF@\ǉ	////
		movf	PORTB,0
		andlw	B'01000000'
		subwf	SiOFF,0
		btfsc	STATUS,Z	; if PORTB.6=	SiOFF rhen skip
		goto	mn6

 		btfsc	PORTB,6		;if PORTA3=H, then skip
		goto	mn55
		btfss	PORTB,6		;if PORTA3=L, then Si5351 OFF
		goto	mn52

mn52	call	Si53Off
		bcf		SiOFF,6
		goto	mn6	

mn55	call	Si53ON
		bsf		SiOFF,6
		goto	mn6	
			;//2025.12.31  Si5351 OFF@\ǉ	////܂

mn6	;	call	LED	;test
			;====RB0`RB3̕ω============call	readb
	bsf		STATUS,RP0	;oN1	;rb.2-7s input mode
		movlw	B'11111111'	;rb.0-7sin  !rb,#11111111b
		movwf	TRISB		;trisb
	bcf		STATUS,RP0	;oN0
		clrf	PORTB

		movf	PORTB,0			;Rb0-3̕ω`FbN
		andlw	B'00001111'
		movwf	Rb30 	;Rb3-0 ̕ۑWX^
		movf	Rb30,0
	call	LEDOff	;test 

		sublw	B'00001111' 	;
     	btfss	STATUS,Z		;if PORTB=B'xxxx1111' ,then skip  
		goto	RBcheck 

mn7		bsf		INTCON,GIE		;荞݊Jn
mn75	bcf		STATUS,RP0	;bank0
		btfss	vfc,0	
		goto	main
	;----------------
mn8		nop
mn81	bcf		INTCON,GIE	;荞݋֎~
	bcf		STATUS,RP0	;bank0
		clrf	vfc

		call	Si5351		;Si5351a control Parameer 						 /690cycle
	;call	LED
		call	MSN_Reg	;MSNA_Px@;Register 26 and 27,28,29,30,31,32,33 /4,100cycle
		clrf	vfc
	;call	LEDOff	
		bsf		INTCON,GIE	;荞݊Jn
		call	putfre		;											 //300cycle
		btfsc	vfc,0
		goto	mn5
		call	dp_Fre	;	;LCDg@1s5`16@12\				//4,000cycle	
		btfsc	vfc,0
		goto	mn5
		goto	main
	;------------------
	;------------------

;-------------------------------------------
Si5351	bsf		STATUS,RP0	;bank1  /690cycle
;prg order [call	MSN3Cal][call	MSN1Cal][call	MSN2Cal][call	MSNset]
	;	call	MSN3Cal		;MSNx_P3[19:0]= c //Always Fixed  c =250,000 =H'3 d0 90'	
		call	MSN1Cal		;MSNx_P1[17:0]=128 x a +Floor(128x(b/c))-512 EEE@    /390cycle
		call	MSN2Cal		;MSNx_P2[19:0]= 128 x b - c x Floor(128x(b/c)@@EEEA //300cycle
		return
;----------------
MSN_Reg	bsf		STATUS,RP0	;bank1 /400+ 300x9 =4,100cycle
	;=========== test ===================; MSNA_Px̉lDebagptest̊Jn---	
	;	movlw	H'90'	;;P3N[19:0]=  c =250,000	=H'3 d0 90'	
	;	movwf	P3N_0	;Band7 10.5MHz	 
	;	movlw	H'd0'
	;	movwf	P3N_1		
	;	movlw	H'03'
	;	movwf	P3N_2		
	;=========== test ===================
	;	movlw	H'14'	;;P1N[17:0]= H'0 08 14'	
	;	movwf	P1N_0		 
	;	movlw	H'08'
	;	movwf	P1N_1		
	;	movlw	H'00'
	;	movwf	P1N_2		
	;=========== test ===================
	;	movlw	H'c0'	;;P2N[19:0]= H'01 d4 c0'	
	;	movwf	P2N_0		 
	;	movlw	H'd4'
	;	movwf	P2N_1		
	;	movlw	H'01'
	;	movwf	P2N_2		
	;============ test    ==================; MSNA_Px̉ltest̏I----
;	bsf		STATUS,RP0	;bank1
;		movlw	B'11000000'			;fobO@vO Ȃ̂Ł@ɒuĂ
;		xorwf	P1N_0,0
;	bcf		STATUS,RP0	;bank0
;		movwf	dsp1
;	bsf		STATUS,RP0	;bank1		
;		movlw	B'11000000'
;		xorwf	P1N_1,0
;	bcf		STATUS,RP0	;bank0
;		movwf	dsp2
;	bsf		STATUS,RP0	;bank1
;		movlw	B'11000000'
;		xorwf	P1N_2,0
;	bcf		STATUS,RP0	;bank0
;		movwf	dsp3
;		bcf		STATUS,RP0	;bank0
;		call	dp_st	;step LCd\
;============ test    ==================; MSNA_Px̉ltest̏I----

	bsf		STATUS,RP0	;bank1
		movlw	D'26'	;Register 26 and 27,28,29,30,31,32,33
		movwf	Regnum
		call	Si53_regi	;uI_start  I_adres@ˁ@I_ack@	I_register@data	@ˁ@I_ackv

		movf	P3N_1,0		; Reg26
		movwf	dat_Si
		call	Si53_data	;uI_data	@ˁ@I_ackv

		movf	P3N_0,0		; Reg27
		movwf	dat_Si
		call	Si53_data

		movf	P1N_2,0		; Reg28
		movwf	dat_Si
		call	Si53_data

		movf	P1N_1,0		; Reg29
		movwf	dat_Si
		call	Si53_data

		movf	P1N_0,0		; Reg30
		movwf	dat_Si
		call	Si53_data

		swapf	P3N_2,0		;P3N_2[19:16]
		andlw	B'11110000'
		xorwf	P2N_2,0		; Reg31	P3N_2[19:16]  +P2N_2[19:16]	
		movwf	dat_Si
		call	Si53_data

		movf	P2N_1,0		; Reg32
		movwf	dat_Si
		call	Si53_data

		movf	P2N_0,0		; Reg33
		movwf	dat_Si
		call	Si53_data
		call	I_stop		;Stop
	bcf		STATUS,RP0	;bank0
		return

;-----------------
Si53Off	bsf		STATUS,RP0	;bank1
		movlw	D'3'	;Register 3
		movwf	Regnum
		movlw	H'FF'	;Register3	Data=H'FE' //bit0=0  only CLK0 enable Output
		movwf	dat_Si	
		call	Si53_load
				;uI_start  I_adres@ˁ@I_ack@	I_register data	@ˁ@I_ack ˁ@I_data@ˁ@I_ack@ I_stopv

		bsf		STATUS,RP0	;bank1
		movlw	D'16'	;Register 16
		movwf	Regnum
		movlw	H'80'	;CLK0 power down' //bit8=1,CLK0 OutputPower Off.
		movwf	dat_Si	
		call	Si53_load
	bcf		STATUS,RP0	;bank0	
		return
;-----------------
Si53ON	bsf		STATUS,RP0	;bank1
		movlw	D'16'	;Register 16
		movwf	Regnum
		movf	Rg16,0	;Register16	Data=H'4F' //if bit8=0,CLK0 OutputPowered. if bit7=1, MultiSynth Intger;
		movwf	dat_Si				;=4 ̂Ƃ́Abit6=1 must
		call	Si53_load

		movlw	D'177'	;Register 177
		movwf	Regnum
		movlw	H'AC'	;Register177	Data=H'A0'// PLLA Reset(bit5) and PLLB Reset(bit7)
		movwf	dat_Si	
		call	Si53_load
	
		movlw	D'3'	;Register 3
		movwf	Regnum
		movlw	H'FE'	;Register3	Data=H'FE' //bit0=0  only CLK0 enable Output
		movwf	dat_Si	
		call	Si53_load
				;uI_start  I_adres@ˁ@I_ack@	I_register data	@ˁ@I_ack ˁ@I_data@ˁ@I_ack@ I_stopv
	;--------------------
	bcf		STATUS,RP0	;bank0
		return
;-----------------
Si53Reset
	bsf		STATUS,RP0	;bank1
		movlw	D'16'	;Register 16
		movwf	Regnum
		movf	Rg16,0	;Register16	Data=H'4F' //if bit8=0,CLK0 OutputPowered. if bit7=1, MultiSynth Intger;
		movwf	dat_Si				;=4 ̂Ƃ́Abit6=1 must
		call	Si53_load

		movlw	D'177'	;Register 177
		movwf	Regnum
		movlw	H'AC'	;Register177	Data=H'AC'// PLLA Reset(bit5) and PLLB Reset(bit7)
		movwf	dat_Si	
		call	Si53_load

		movlw	D'3'	;Register 3
		movwf	Regnum
		movlw	H'FE'	;Register3	Data=H'FE' //bit0=0  only CLK0 enable Output
		movwf	dat_Si	
		call	Si53_load
				;uI_start  I_adres@ˁ@I_ack@	I_register data	@ˁ@I_ack ˁ@I_data@ˁ@I_ack@ I_stopv
		return
;---------------------荞ݏuroutin------------
		;--------------	ȉ@Encoder x1{ ̏	
Enc_1	movlw	B'11100000'		;old_BA=11, new_BA=10 then 1110+0000
		subwf	xor45bit,0
		btfsc	STATUS,Z
		goto	isadd

		movlw	B'01000000'		;old_BA=01, new_BA=00 then 0100+0000
		subwf	xor45bit,0
		btfsc	STATUS,Z
		goto	issub
		goto	pop1
		;--------------	ȉ@Encoder x4{ ̏
Enc_4	btfss	step0,0	;if step=200(10kHz)=B'11001000', goto Enc_1
		goto	Enc_1

		movlw	B'11100000'		;old_BA=11, new_BA=10 then 1110+0000
		subwf	xor45bit,0
		btfsc	STATUS,Z
		goto	isadd

		movlw	B'10000000'
		subwf	xor45bit,0
		btfsc	STATUS,Z
		goto	isadd

		movlw	B'00010000'
		subwf	xor45bit,0
		btfsc	STATUS,Z
		goto	isadd

		movlw	B'01110000'		
		subwf	xor45bit,0
		btfsc	STATUS,Z
		goto	isadd

		movlw	B'11010000'
		subwf	xor45bit,0
		btfsc	STATUS,Z
		goto	issub

		movlw	B'01000000'		;old_BA=01, new_BA=00 then 0100+0000
		subwf	xor45bit,0
		btfsc	STATUS,Z
		goto	issub

		movlw	B'00100000'
		subwf	xor45bit,0
		btfsc	STATUS,Z
		goto	issub

		movlw	B'10110000'
		subwf	xor45bit,0
		btfsc	STATUS,Z
		goto	issub
		goto	pop1
	;-------------------
;-----------------------------
add_v	bsf		STATUS,RP0	;bank1	63cycle
	;H'0000'`b`250,000(0x 03 d0 90)B	;b(24bit)=b(24bit)+step(16bit)
	;H'FF FF FF'-D'249,999'=16527216 =H'FC 2F 70'
		movf	cn_bbt,0
		movwf	scn
; 	Z	b(24bit)b(24bit){H'FC 2F 6F'
add_v0	clrf	Carover	
		movlw	H'70'				;add	x[0],y[0]
		addwf	b0,1
		movlw	1
		btfsc	STATUS,C
		addwf	b1,1
		btfsc	STATUS,C
		addwf	b2,1
		
		movlw	H'2F'				;add	x[1],y[1]
		addwf	b1,1
		movlw	1
		btfsc	STATUS,C
		addwf	b2,1

		movlw	H'FC'				;add	x[2],y[2]	]
		addwf	b2,1
	;Z{H'FC 2F 6F'@============
		movf	step0,0				;add	x[0],y[0]
		addwf	b0,1
		movlw	1
		btfsc	STATUS,C
		addwf	b1,1
		btfsc	STATUS,C
		addwf	b2,1
		btfss	STATUS,C
		goto	add_v1
		addwf	aa,1
		bsf		Carover,0		;if Carover.0=1, aa@̌Jオ
add_v1	movf	step1,0				;add	x[1],y[1]
		addwf	b1,1
		movlw	1
		btfsc	STATUS,C
		addwf	b2,1
		btfss	STATUS,C
		goto	add_v2
		addwf	aa,1
		bsf		Carover,0
add_v2	movf	step2,0				;add	x[2],y[2]
		addwf	b2,1
		movlw	1
		btfss	STATUS,C
		goto	add_v3
		addwf	aa,1
		bsf		Carover,0
add_v3	btfsc	Carover,0 	;if  Carover.0=0iオȂ΁j, H'FC 2F 6F'Z  	
		goto	add_e
; 	Z	b(24bit)b(24bit)-H'FC 2F 70'
		movlw	H'70'				;sub	x[0],y[0]
		subwf	b0,1
		movlw	1
		btfss	STATUS,C
		subwf	b1,1
		btfss	STATUS,C
		subwf	b2,1

		movlw	H'2F'				;sub	x[1],y[1];
		subwf	b1,1
		movlw	1
		btfss	STATUS,C
		subwf	b2,1

		movlw	H'FC'				;sub	x[2],y[2];
		subwf	b2,1		
		decfsz	scn,1
		goto	add_v0
add_e	bcf		STATUS,RP0	;bank0
		return

	;==================
	;-----------------
sub_v	bsf		STATUS,RP0	;bank1
	;H'0000'`b`250,000(0x 03 d0 90)B	
	;b(24bit)=b(24bit)-step(16bit)
		movlw	D'18'
		subwf	aa,0	;W= aa + (256-18)
		btfss	STATUS,C	;if aa<18 , then goto End
		goto	sub_e
		
		movf	cn_bbt,0
		movwf	scn
	
sub_v0	clrf	Carover
		movf	step0,0				;sub	x[0],y[0]
		subwf	b0,1
		movlw	1
		btfss	STATUS,C
		subwf	b1,1
		btfss	STATUS,C
		subwf	b2,1
		btfsc	STATUS,C
		goto	sub_v1
		subwf	aa,1
		bsf		Carover,0
sub_v1	movf	step1,0				;sub	x[1],y[1];
		subwf	b1,1
		movlw	1
		btfss	STATUS,C
		subwf	b2,1
		btfsc	STATUS,C
		goto	sub_v2
		subwf	aa,1
		bsf		Carover,0
sub_v2	movf	step2,0				;sub	x[2],y[2];
		subwf	b2,1
		movlw	1
		btfsc	STATUS,C
		goto	sub_v3
		subwf	aa,1
		bsf		Carover,0
sub_v3	btfss	Carover,0	;if Carover.0=1(J艺肠), Z-H'FC 2F 6F'@
		goto	sub_e
; 	Z	b(24bit)b(24bit)-H'FC 2F 70'(=16527216 )
		movlw	H'70'				;sub	x[0],y[0]
		subwf	b0,1
		movlw	1
		btfss	STATUS,C
		subwf	b1,1
		btfss	STATUS,C
		subwf	b2,1

		movlw	H'2F'				;sub	x[1],y[1];
		subwf	b1,1
		movlw	1
		btfss	STATUS,C
		subwf	b2,1

		movlw	H'FC'				;sub	x[2],y[2];
		subwf	b2,1		
		decfsz	scn,1
		goto	sub_v0
sub_e	bcf		STATUS,RP0	;bank0
		return
;-----------------------
;	Check for STEP, Band, Memory step_change=============
RBcheck bcf		INTCON,GIE		;荞݋֎~ 
		call	readb

RBck1	call	wt4ms
		movf	PORTB,0
		andlw	B'00001111'
		sublw	B'00001111'
		btfss	STATUS,Z
		goto	RBck1

		btfss	Rb30,0
		goto	stp_chg
		btfss	Rb30,1
		goto	Bnd_chg		
		btfss	Rb30,2
		goto	F_save
		bsf		INTCON,GIE	;荞݊Jn 
		goto	mn7

F_save	call	sav_ini
		bsf		INTCON,GIE	;荞݊Jn 
		goto 	mn7
;--------------------------------
stp_chg		;25Hz(step=0.25 x dd x2), 50Hz(step=0.5 xddx2), 500Hz(step=5 xddx2), 10kHz(step=100 xddx2), 100kHz(step=1000 xddx2)  
			;;N_step =0(25H) ,1(50Hz), 2(500Hz) ,3(10kHz), 4(100kHz), 5(1MHz:Band11(dd=6)ȏ̂)
	bcf		STATUS,RP0	;bank0
		
		movlw	D'11'
		subwf	Nband,0	;W= Nband +(256 -11)
		btfsc	STATUS,C
		goto	stpc_H
		goto	stpc_L

stpc_L	movlw	D'5'		;if N_step>=5, N_step=4
		subwf	N_step,0 	;W=N_step + (256-5)
		movlw	D'4'
		btfss	STATUS,C 
		movf	N_step,0
		movwf	N_step

		incf	N_step,1	;N_step= N_step+1 (0<= Nband <=3)
		movf	N_step,0
		sublw	D'5'		;W=4 +(256- N_step)
		movlw	D'0'	
		btfss	STATUS,Z
		movf	N_step,0
		movwf	N_step
	bsf		STATUS,RP0	;bank1
		movwf	N2_step	
	bcf		STATUS,RP0	;bank0
		call	stp_set
		goto	mn7

stpc_H	incf	N_step,1	;N_step= N_step+1 (0<= Nband <=4)
		movf	N_step,0
		sublw	D'6'		;W=4 +(256- N_step)
		movlw	D'0'	
		btfss	STATUS,Z
		movf	N_step,0
		movwf	N_step
	bsf		STATUS,RP0	;bank1
		movwf	N2_step	
	bcf		STATUS,RP0	;bank0

		call	stp_set
		goto	mn7

Bc_stp	movlw	D'5'		;if Nband <=11, Max N_step must be =3
		subwf	N_step,0
		movlw	D'4'
		btfss	STATUS,Z
		movf	N_step,0
		movwf	N_step
	bsf		STATUS,RP0	;bank1
		movwf	N2_step	
	bcf		STATUS,RP0	;bank0

stp_set	movlw	0	
		subwf	N_step,0
		btfsc	STATUS,Z 	;if N_step =0 ,then goto st25	
		goto	st25

		movlw	1	
		subwf	N_step,0
		btfsc	STATUS,Z 	;if N_step =0 ,then goto st50	
		goto	st50

		movlw	2	
		subwf	N_step,0
		btfsc	STATUS,Z 	;if N_step =1 ,then goto st05k	
		goto	st05k

		movlw	3	
		subwf	N_step,0
		btfsc	STATUS,Z 	;if N_step =1 ,then goto st10k	
		goto	st10k

		movlw	4	
		subwf	N_step,0
		btfsc	STATUS,Z 	;if N_step =1 ,then goto st100k	
		goto	st100k

		movlw	5	
		subwf	N_step,0
		btfsc	STATUS,Z 	;if N_step =1 ,then goto st1M	
		goto	st1M
		return

st25	bsf		STATUS,RP0	;bank1
		movf	dd,0		;25Hz(step=0.25 x dd x2)
		movwf	step0
		clrf	step1
		clrf	step2
		bcf		STATUS,C
		rrf		step0,1

		movlw	D'1'
		movwf	cn_bbt

	bcf		STATUS,RP0	;bank0
		movlw	H'20'	;u025Hv
		movwf	dsp1
		movlw	H'32'	;u025Hv
		movwf	dsp2
		movlw	H'35'	;u025Hv
		movwf	dsp3
		movlw	H'48'	;uHv
		movwf	dsp4
		goto	stend

st50	bsf		STATUS,RP0	;bank1
		movf	dd,0		;50Hz(step=0.5 x dd x2)
		movwf	step0
		clrf	step1
		clrf	step2
		movlw	D'1'
		movwf	cn_bbt

	bcf		STATUS,RP0	;bank0
		movlw	H'20'	;u050Hv
		movwf	dsp1
		movlw	H'35'	;u050Hv
		movwf	dsp2
		movlw	H'30'	;u050Hv
		movwf	dsp3
		movlw	H'48'	;uHv
		movwf	dsp4
		goto	stend
			;UgGF(100HzP) o (25,000x10x a) + b p/d
			;step50Hzł́A 0.5=b/d =b/(2 x dd) b(50Hz)= 0.5 x(2 x dd)= dd
			;step500Hzł́A 5=b/d =b/(2 x dd) b(500Hz)= 5 x(2 x dd)=10 x dd	
			;step10kHzł́A 100=b/d =b/(2 x dd) b(10kHz)= 200 x dd	
			;step100kHzł́A 1000=b/d =b/(2 x dd) b(100kHz)= 2000 x dd	
			;10{́A8 +2 ,200{́A128+64+8 ,2000{́A1024+512+256+128+64+16
		;step[24bit]=step[24bit]+ k[24bit] ̌vZ@Bank1

st05k	bsf		STATUS,RP0	;bank1 b(500Hz)= 10 x dd=(8 +2)x dd	
		movf	dd,0
		movwf	k0
		clrf	k1
		clrf	k2

		call	k_x2	;k= k x 2 = dd x2
		movf	k0,0
		movwf	step0	;step= k x 2 = dd x2 
		movf	k1,0
		movwf	step1
		movf	k2,0
		movwf	step2

		call	k_x4	;k= k x 2^2 = dd x8
		call	add_step	;step[24bit]=step[24bit]+ k[24bit] 
		movlw	D'1'
		movwf	cn_bbt

	bcf		STATUS,RP0	;bank0
		movlw	H'35'	;u500Hv
		movwf	dsp1
		movlw	H'30'	;u500Hv
		movwf	dsp2
		movlw	H'30'	;u500Hv
		movwf	dsp3
		movlw	H'48'	;uHv
		movwf	dsp4
		goto	stend

st10k	bsf		STATUS,RP0	;bank1 	b(10kHz)= 200 x dd=(128+64+8) x dd
		movf	dd,0
		movwf	k0
		clrf	k1
		clrf	k2

		call	k_x8	;k= k x 2^3 = dd x8
		movf	k0,0
		movwf	step0	;step= k x 8 = dd x8 
		movf	k1,0
		movwf	step1
		movf	k2,0
		movwf	step2

		call	k_x8	;k= k x 2^6 = dd x64
		call	add_step	;step=(8+64) xdd	;step[24bit]=step[24bit]+ k[24bit] 
		call	k_x2	;k= k x 2^7 = dd x128
		call	add_step	;step=(8+64+128) xdd	;step[24bit]=step[24bit]+ k[24bit] 
		movlw	D'1'
		movwf	cn_bbt

	bcf		STATUS,RP0	;bank0
		movlw	H'20'	;u10kv
		movwf	dsp1
		movlw	H'31'	;u10kv
		movwf	dsp2
		movlw	H'30'	;u10kv
		movwf	dsp3
		movlw	H'6B'	;ukv
		movwf	dsp4
		goto	stend

st100k	bsf		STATUS,RP0	;bank1  b(100kHz)= 2000 x dd=(1024+512+256+128+64+16) x dd
		movf	dd,0
		movwf	k0
		clrf	k1
		clrf	k2

		call	k_x16	;k= k x 2^4 = dd x16
		movf	k0,0
		movwf	step0	;step= k x 16 = dd x16 
		movf	k1,0
		movwf	step1
		movf	k2,0
		movwf	step2

		call	k_x4	;k= k x 2^6 = dd x64
		call	add_step	;step=(16+64) xdd	;step[24bit]=step[24bit]+ k[24bit] 
		call	k_x2	;k= k x 2^7 = dd x128
		call	add_step	;step=(16+64+128) xdd	;step[24bit]=step[24bit]+ k[24bit]
		call	k_x2	;k= k x 2^8 = dd x256
		call	add_step	;step=(16+64+128+256) xdd	;step[24bit]=step[24bit]+ k[24bit]
		call	k_x2	;k= k x 2^9 = dd x512
		call	add_step	;step=(16+64+128+256+512) xdd	;step[24bit]=step[24bit]+ k[24bit]
		call	k_x2	;k= k x 2^10 = dd x1024
		call	add_step	;step=(16+64+128+256+512+1024) xdd	;step[24bit]=step[24bit]+ k[24bit]
		movf	cn_bb,0
		movwf	cn_bbt

  		movlw	D'4'
		subwf	cn_bb,0
		btfsc	STATUS,Z
		call	st_4	;step= step x 1/4

  		movlw	D'2'
		subwf	cn_bb,0
		btfsc	STATUS,Z
		call	st_2	;step= step x 1/2	

	bcf		STATUS,RP0	;bank0
		movlw	H'31'	;u100kv
		movwf	dsp1
		movlw	H'30'	;u100kv
		movwf	dsp2
		movlw	H'30'	;u100kv
		movwf	dsp3
		movlw	H'6B'	;ukv
		movwf	dsp4
		goto	stend

st1M	bsf		STATUS,RP0	;bank1  b(1000kHz)= 20000 x dd=2x(8192+1024+512+256+16) x dd
		movf	dd,0
		movwf	k0
		clrf	k1
		clrf	k2

		call	k_x16	;k= k x 2^4 = dd x16
		movf	k0,0
		movwf	step0	;step= k x 16 = dd x16 
		movf	k1,0
		movwf	step1
		movf	k2,0
		movwf	step2

		call	k_x16	;k= k x 2^8 = dd x256
		call	add_step	;step=(16+256) xdd	;step[24bit]=step[24bit]+ k[24bit] 
		call	k_x2	;k= k x 2^9 = dd x512
		call	add_step	;step=(16+256+512) xdd	;step[24bit]=step[24bit]+ k[24bit]
		call	k_x2	;k= k x 2^10 = dd x1024
		call	add_step	;step=(16+256+512+1024) xdd	;step[24bit]=step[24bit]+ k[24bit]
		call	k_x8	;k= k x 2^13 = dd x8192
		call	add_step	;step=(16+256+512+1024+8192) xdd	;step[24bit]=step[24bit]+ k[24bit]
		bcf		STATUS,C
		rlf		step0,1
		rlf		step1,1
		rlf		step2,1

		movf	cn_bb,0
		movwf	cn_bbt

 	bcf		STATUS,RP0	;bank0
		movlw	H'20'	;u_v
		movwf	dsp1
		movlw	H'20'	;u_v
		movwf	dsp2
		movlw	H'31'	;u1v
		movwf	dsp3
		movlw	H'4D'	;uMv
		movwf	dsp4
		goto	stend

stend	bcf		STATUS,RP0	;bank0
		call	dp_st	;step LCd\
		return
		
	;------------------
k_x64	bcf		STATUS,C
		rlf		k0,1
		rlf		k1,1
		rlf		k2,1
k_x32	bcf		STATUS,C
		rlf		k0,1
		rlf		k1,1
		rlf		k2,1
k_x16	bcf		STATUS,C
		rlf		k0,1
		rlf		k1,1
		rlf		k2,1
k_x8	bcf		STATUS,C
		rlf		k0,1
		rlf		k1,1
		rlf		k2,1
k_x4	bcf		STATUS,C
		rlf		k0,1
		rlf		k1,1
		rlf		k2,1
k_x2	bcf		STATUS,C
		rlf		k0,1
		rlf		k1,1
		rlf		k2,1
		return
		;----------------
st_4	bcf		STATUS,C
		rrf		step2,1
		rrf		step1,1
		rrf		step0,1
st_2	bcf		STATUS,C
		rrf		step2,1
		rrf		step1,1
		rrf		step0,1
		return
		;---------------

;----------------------------
Bnd_chg	bcf		STATUS,RP0	;bank0
			;1.0 `, 200MHz	
			; 0 , 1 , 2, 3, 4, 5,   6, 7, 		14=Nband
		incf	Nband,1	;Nband= Nband+1 (0<= Nband <=7)
		movlw	D'15'
		subwf	Nband,0
		movlw	D'0'	
		btfss	STATUS,Z
		movf	Nband,0
		movwf	Nband
	bsf  	STATUS,RP0	;oN1
		movwf	N2_bnd		
	bcf  	STATUS,RP0	;oN0
		movf	Nband,0
		call	Bnd_set
		call	Bc_stp ;Band́@steplݒ

		call	MSx1		;/ݒvZ
		call	Si53Off	;Si5351 OFF
		call	MSx1_Reg	;/탌WX^Register42-49
		call	Si53ON	;Reg 3 ON

		bsf		INTCON,GIE	;荞݊Jn
 		bsf		vfc,0		;vfo change record
		goto	mn7	

Bnd_set	movf	Nband,0
	bsf  	STATUS,RP0	;oN1
		movf	N2_bnd,0
	bsf		PCLATH,3	;̈GPage1 ւ̐ؑ
;	bcf		PCLATH,4	
		call	B_data	;setting aa, b0, b1, dd, cn_bb
	bcf		PCLATH,3	;̈GPage0 ֖߂
;	bcf		PCLATH,4

BndN	bcf  	STATUS,RP0	;oN0
		movf	Nband,0	;gєԍLCD\@Nband0`14
		movwf	val0
		call	dc8		;Val0(y[0]:y[1]:y[2])
		movf	y1,0
		movwf	Bnum0
		movf	y2,0
		movwf	Bnum1

BndL	movf	Nband,0
		movwf	poi
		bcf		STATUS,C
		rlf		poi,1		;poi=poi x2
		movf	poi,0
		call	B_dsp	;gLCD\ ̎g
		movwf	val0
		call	dc8		;10iϊ@Val0(y[0]:y[1]:y[2])

		btfsc	Nband,3		;;Nband.3=1(8ȏ) Ȃ΁@16MHz̕\ x1{// Nband must be <15
		goto	FrL_x10

FrL_x1	movlw	H'20'
		movwf	BFre1
		movf	y0,0
		movwf	BFre2
		movf	y1,0
		movwf	BFre3	
		movf	y2,0
		movwf	BFre4
		goto	BndH
		
FrL_x10	movf	y0,0
		movwf	BFre1
		movf	y1,0
		movwf	BFre2	
		movf	y2,0
		movwf	BFre3
		movlw	H'30'
		movwf	BFre4
		goto	BndH

BndH	incf	poi,1
		movf	poi,0
		call	B_dsp	;gѕ\ ̎g
		movwf	val0
		call	dc8		;10iϊ@Val0(y[0]:y[1]:y[2])

		btfsc	Nband,3	;;Nband.3=1i8ȏj Ȃ΁@16MHz̕\ x1{
		goto	FrU_x10

FrU_x1	movlw	H'20'
		movwf	BFre5
		movf	y0,0
		movwf	BFre6
		movf	y1,0
		movwf	BFre7	
		movf	y2,0
		movwf	BFre8
		goto	Fre_end
		
FrU_x10	movf	y0,0
		movwf	BFre5
		movf	y1,0
		movwf	BFre6	
		movf	y2,0
		movwf	BFre7
		movlw	H'30'
		movwf	BFre8
		goto	Fre_end

Fre_end	call	dp_2V	;2sځ@LCD\
		return

;========================================
;----------------
;1sSTEPg\ 1cursolړAData mode
;----------------
dp_st	call	writb	;Rb3-1 o̓|[g	
		;-------------------------------------------------------++
		bcf		RS		;1sSTEP\ 1curso5ړ		;	++
		movlw	H'80'										;	++
		movwf	d4											;	++
		call	write_lcd4	;cursor 1s or 2s 1		;	++
		bsf		RS	; RS='H' ;Data input modeֈڍs	++
		;-------------------------------------------------------++
		movlw	D'4'
		movwf	cL
		movlw	D'0'
		movwf	poi
		goto	dp_bun
;----------------
;1s 5ځ`16@g\/ 5cursolړAData mode
;----------------
dp_Fre	;Transmit dec1-dec9, to LCD
		;400k6789.012.345Hz 
		call	writb	;Rb3-1 o̓|[g		
		;-------------------------------------------------------++
		bcf		RS		;1sڎg\ 5curso5ړ		;	++
		movlw	H'84'										;	++
		movwf	d4											;	++
		call	write_lcd4	;cursor 1s or 2s 1		;	++
		bsf		RS	; RS='H' ;Data input modeֈڍs	++
		;-------------------------------------------------------++
		movlw	D'12'
		movwf	cL
		movlw	D'4'
		movwf	poi
		goto	dp_bun
;----------------
;;2s Band Ug@͈͕\ 1cursolړAData mode	
;----------------
dp_2V	call	writb	;Rb3-1 o̓|[g	
		;-------------------------------------------------------++
		bcf		RS		;2sځuBandv\ 1cursolړ		;	++
		movlw	H'C0'										;	++
		movwf	d4											;	++
		call	write_lcd4	;cursor 1s or 2s 1		;	++
		bsf		RS	; RS='H' ;Data input modeֈڍs	++
		;-------------------------------------------------------++
		movlw	D'16'
		movwf	cL
		movlw	D'16'
		movwf	poi
		goto	dp_bun
;------------------------------------------------------------------------
;-------;\郋[`	;\X^ĆAtab_dpɑΉ	;poi=ʒuA0<=poi<tab_dpmaxl
dp_bun		;\				;/16x(35step+40us)=560step+640us
		btfsc	vfc,0
		return
		bsf		RS
dpb1	movf	poi,0
		call	tab_dp
		movwf	d4
		btfsc	d4,7		;if d4.7=1, then dpb4
		goto	dpb4
		;goto	dpb3
dpb3	movwf	FSR		;WX^[AhX
		movf	INDF,0
		movwf	d4
		goto	dpb5

dpb4	bcf		d4,7		;d4ɑΉ镶
dpb5	call	write_lcd4	;
		incf	poi,1
		decfsz	cL,1
		goto	dpb1
		return
	;----------------------
readb	bsf		STATUS,RP0	;oN1	;rb.2-7s input mode
		movlw	B'11111111'	;rb.0-7sin  !rb,#11111111b
		movwf	TRISB		;trisb
		bcf		STATUS,RP0	;oN0
		clrf	PORTB
		return

;---------
writb	bsf		STATUS,RP0	;oN1
		movlw	B'11110000'	; rb.0-rb.3sout  	
		movwf	TRISB		;trisb
		bcf		STATUS,RP0	;oN0
		clrf	PORTB
		return
	;====--------------
;		t[`<HD44780  ST7032>
init_lcd
		bcf		RS			; RS='L'
	;<Function Set> 	
		movlw	B'00110000'	;bit4=1=4bit@mode
		movwf	d8
		call	write_lcd8
		call	wt15ms			; wait 4.1msȏ

		movlw	B'00110000'	;
		movwf	d8
		call	write_lcd8
		call	wt100u			; wait 100usȏ

		movlw	B'00110000'	;
		movwf	d8
		call	write_lcd8
		call	wt100u			; wait 100us

	;<4 bit mode> 
		movlw	B'00100000'	;
		movwf	d8
		call	write_lcd8
		call	wt100u			; wait 100us

	;<4 bit mode> 
	;<Function Set> 
		movlw	B'00101000'		;bit4=0=4bit mode, bit3=1=2-line,bit2=0
		movwf	d4
		call	write_lcd4
		call	wt100u		; 

	;<Display ON/OFF Control> 
		movlw	B'00001100'	;bit3=D=1=Display on, bit2=C=1=Cursol on,
		movwf	d4
		call	write_lcd4

	;<Display Clear>
		movlw	B'00000001'		;
		movwf	d4
		call	write_lcd4
		call	wt15ms		; NAI܂ő҂ 1.6mbȏ	call	wt100u			; wait 100us

	;<Entry mode set>B'00010100'	
		movlw	B'00000110'		;bit=1=Increment mode, bit0=1=Entire shift on
		movwf	d4
		call	write_lcd4
		call	wt15ms		; NAI܂ő҂ 1.6mbȏ

	;<Display Off>
	;	movlw	B'00001000'		;
	;	movwf	d4
	;	call	write_lcd4	

		return
;----------------------------------------
;----------------------------------------
;		Srbg[hptCg[`
write_lcd4	;290cycle
		movf	d4,0		;mov	d8,d4
		movwf	d8
		call	write_lcd8		;4ޯ	;140cy
wr45	movf	d4,0		;	mov	d8,d4
		movwf	d8
		swapf	d8,1
		call	write_lcd8		;ʂSޯ	;140cy
		return
;
;		Wrbg[hptCg[`
;
write_lcd8	;140cy
				;d8.7d8.0;//d8.6d8.1//;;d8.5d8.2//;;;d8.4d8.3
		rlf		d8,1		;d8.7ct0.4
		rrf		ct0,1
		rlf		d8,1		;d8.6ct0.5
		rrf		ct0,1
		rlf		d8,1		;d8.5ct0.6
		rrf		ct0,1
		rlf		d8,1		;d8.4ct0.7
		rrf		ct0,1
		swapf	ct0,0				;movf	ct0,0

		andlw	B'00001111'	
		movwf	PORTB	
	
		bsf		E			; ds'H'
		nop
		bcf		E
		movlw	D'40'	;mov	wait_cn,#40 ;3*40=120cy
		movwf	wait_cn		
		call	wait_us
		return
;--------------------------------------
putfre	; Freq(Hz)=(25,000 x1000) x ( a + b/c)@/(d+ e/f) (Ɂ@c=250,000, e=0 /300cycle
		; Freq(Hz)=(25,000 x1000) x ( a + b/250,000)@/d  (Ɂ@a=20 4<d<510)
		;Freq(100Hz) ={(25,000 x10 x a) + b } /d  
	;---
	;---(25,000 x10 x a) EEE H'03 D0 90' x a
		movlw	H'90'	;25,000 x10 = H'03 D0 90'
		movwf	zz0
		movlw	H'D0'
		movwf	zz1	
		movlw	H'03'
		movwf	zz2

	bsf		STATUS,RP0 	;bank1
		movf	aa,0
	bcf		STATUS,RP0 	;bank0
		movwf	N
		call 	mult_vN		;x[32bit]=zz[24bit] * N[8bit]// x= 250,000 x a

	bsf		STATUS,RP0 	;bank1  b ˁ@k
		movf	b0,0
		movwf	k0
		movf	b1,0
		movwf	k1
		movf	b2,0
		movwf	k2
	bcf		STATUS,RP0 	;bank0
		movf	k0,0	;y(bank0) = b(bank1)
		movwf	y0
		movf	k1,0
		movwf	y1	
		movf	k2,0
		movwf	y2
		clrf	y3
	;	clrf	x3		;2024.05.21 Cdelete
		call	add_xy	;(32bit)(32bit){y(32bit)@//x=250,000 x a + b 

		btfsc	PORTA,2		;if PORTA=H, then Frequency Non Adjust
		goto 	pf4

		clrf	y3
		clrf	y2
		movf	x3,0		; y= x x 2^(-16)
		movwf	y1
		movf	x2,0
		movwf	y0
		call	add_xy	;(32bit)(32bit){y(32bit)@//25,000.0kHz 2^(-16)=3.81 (=381Hz␳)

		bcf		STATUS,C
		rrf		y1,1
		rrf		y0,1
		call	add_xy	;(32bit)(32bit){y(32bit)@//25,000.0kHz 2^(-17)=3.81 (=381+190=571Hz␳)		

pf4	bsf		STATUS,RP0 	;bank1  d ˁ@y
		movf	dd,0
	bcf		STATUS,RP0 	;bank0
		movwf	y0
		clrf	y1
		bcf		STATUS,C	;y= y@2 ;dd́Aۂd́@1/2Ȃ̂Ł@d=dd x2// (250,000 x a + b ) /(dd x2)
		rlf		y0,1
		rlf		y1,1

		call	Div_xYY	;	val<32bit> = x<32bit> / y<16bit>
							; val= (250,000 x a + b ) /(dd x2) 
pf5		btfsc	PORTA,1		;if PORTA.1=L ,then IF offset
		goto	pf6

		movf	val0,0
		movwf	x0
		movf	val1,0
		movwf	x1
		movf	val2,0
		movwf	x2
		movf	val3,0
		movwf	x3

		movf	Ifre0,0
		movwf	y0
		movf	Ifre1,0
		movwf	y1
		movf	Ifre2,0
		movwf	y2
		clrf	y3

		btfss	PORTA,0 	;if PORTA.0=1, Upper Hetro
		call	add_xy	;(32bit)(32bit){y(32bit) ;x= x + IF ;Lowr Hetrodyne
		btfsc	PORTA,0 	;if PORTA.0=1, Upper Hetro
		call	sub_xy	;(32bit)(32bit)|y(32bit)@;x= x - IF ;Upper Hetrodyne

		movf	x0,0
		movwf	val0
		movf	x1,0
		movwf	val1
		movf	x2,0
		movwf	val2
		movf	x3,0
		movwf	val3

pf6		call	dcmain		;16i-10iϊ	/4900step	
		return
;=================================

wt4ms	movlw	D'4'			;	mov	wait_cn,#4		; wait 4ms
		movwf	wait_cn		
		goto	wait_ms

wt15ms	movlw	D'15'			;	mov	wait_cn,#15		; wait 15ms
		movwf	wait_cn		
		goto	wait_ms

wt250ms	movlw	D'200'			;	mov	wait_cn,#15		; wait 250ms
		movwf	wait_cn		
		goto	wait_ms
;    --------------------------------------------------------------------
;  ---------------------------------------------------------------
wt100u	movlw	D'100'	;wait 100sec
		movwf	wait_cn
		goto	wait_us

wt40u	movlw	D'40'	;wait 100sec
		movwf	wait_cn
		goto	wait_us

wt2u	movlw	D'2'
		movwf	wait_cn	;1 usec҂
wait_us				;3 steps=1.2ʂ̃JEg
wait_us0
		decfsz	wait_cn,1	;1cycle
		goto	wait_us0		;2cycle
		return

;		I[_[̃EFCg
;
wait_ms
wait_ms0
		movlw 	D'0'
		movwf	wait_cn2
wait_ms1
	;	nop	
		nop
		nop
		nop
		nop	
		nop
		nop
		
		decfsz	wait_cn2,1
		goto	wait_ms1

		decfsz	wait_cn,1
		goto	wait_ms0
		return
;-----------------------
load_IF	bsf		STATUS,RP0	;bank1
		movlw	H'9'
		movwf	ADDR
		movlw	D'3'      
		movwf	scn

		movlw	Ifre0     ;Ifre0, Ifre1, Ifre2 3Aaddress
		movwf	FSR
		goto	load_rt
;-----------------------
load_m	bsf		STATUS,RP0	;bank1
		movlw	H'0'
		movwf	ADDR
		movlw	D'9'      
		movwf	scn

		movlw	ROM1   ;ROM1,N2_bnd, b0,b1,b2, aa,dd,cn_bb,N2_step 9Aaddress  
		movwf	FSR
load_rt	bcf		STATUS,RP0	;Bank2/Select Bank of EEADR
		bsf		STATUS,RP1	;Bank2/
		
		movf	ADDR,0      	;EEPROM address 0&h
		movwf	EEADR		; Data Memory Address to read

		bsf		STATUS,RP0		;Bank3/	Select Bank of EECON1
		bcf		EECON1,EEPGD	; Select Bank of EECON1
		bsf		EECON1,RD		; EE Read

		bcf		STATUS,RP0		;Bank2/ Select Bank of EEDAT
		movf	EEDAT,0      
		movwf	INDF

		incf	ADDR,1
		incf	FSR,1
		decfsz	scn,1
		goto	load_rt

		bcf		STATUS,RP0	;Bank0
		bcf		STATUS,RP1

		bsf		STATUS,RP0	;Bank1
		movf	N2_bnd,0
		bcf		STATUS,RP0	;Bank0
		movwf	Nband
		return
;    ------------------------------------
sav_IF	bcf		STATUS,RP0	;Bank0
		movlw	H'9'
		movwf	ADDR
		movlw	D'3'      
		movwf	scn
		movlw	Ifre0     ;Ifre0, Ifre1, Ifre2 3Aaddress
		movwf	FSR
savIF5	movf	INDF,W
		movwf	VALUE
		call	datawrite

		incf	ADDR,1
		incf	FSR,1
		decfsz	scn,1
		goto	savIF5
		bcf		STATUS,RP0	;bank0
		bcf		STATUS,RP1
		return

;    ------------------------------------
sav_ini	bcf		STATUS,RP0	;Bank0
		movf	Nband,0
		bsf		STATUS,RP0	;bank1	;
		movwf	N2_bnd
		movlw	H'0'
		movwf	ADDR
		movlw	D'9'      
		movwf	scn
		movlw	ROM1     ;ROM1,N2_bnd, b0,b1,b2, aa,dd,cn_bb,N2_step 9Aaddress
		movwf	FSR
sav_i5	movf	INDF,W
		movwf	VALUE
		call	datawrite

		incf	ADDR,1
		incf	FSR,1
		decfsz	scn,1
		goto	sav_i5
		bcf		STATUS,RP0	;bank0
		bcf		STATUS,RP1
		return
;   ----------------------------------------		
datawrite	
		BANKSEL EEADR ;Bank2
		movf	ADDR,W
		movwf	EEADR		;Data Memory Address to write

		movf 	VALUE,W  	;
		movwf	EEDAT 		; Data Memory Value to write

		BANKSEL EECON1 ;;Bank3/	Select Bank of EECON1
		bcf		EECON1,EEPGD	;; Point to DATAmemory 	
		bsf		EECON1,WREN		;WRENޯ on; Enable writes

		bcf		INTCON,GIE 		; Disable INTs
		btfsc	INTCON,GIE		;see AN576
		goto	$-2
	;-----
		MOVLW 	H'55' ;
		MOVWF 	EECON2 ;Write 55h
		MOVLW 	H'AA' ;
		MOVWF 	EECON2 ;Write AAh
		BSF 	EECON1, WR ;Set WR bit to begin write
		BSF 	INTCON, GIE ;Enable INTs.
	;----
		BCF 	STATUS, RP0 ;Bank 0
		BCF 	STATUS, RP1	;Bank 0
		call	wt15ms

		BANKSEL EECON1 ;;Bank3/	Select Bank of EECON1
		BCF 	EECON1, WREN ;Disable writes
		BCF 	STATUS, RP0 ;Bank 0
		BCF 	STATUS, RP1	;Bank 0
		return

;-----------------------
;	Z		(32bit)(32bit)|y(32bit)@
sub_xy
		movf	y0,0				;sub	x[0],y[0]
		subwf	x0,1
		movlw	1
		btfss	STATUS,C
		subwf	x1,1
		btfss	STATUS,C
		subwf	x2,1
		btfss	STATUS,C
		subwf	x3,1

		movf	y1,0				;sub	x[1],y[1];
		subwf	x1,1
		movlw	1
		btfss	STATUS,C
		subwf	x2,1
		btfss	STATUS,C
		subwf	x3,1

		movf	y2,0				;sub	x[2],y[2];
		subwf	x2,1		
								
		movlw	1
		btfss	STATUS,C
		subwf	x3,1
		
		movf	y3,0				;sub	x[3],y[3]
		subwf	x3,1								
		return
;--------------------------------------------------------------------
; 	Z	(32bit)(32bit){y(32bit)@
;
add_xy				
		movf	y0,0				;add	x[0],y[0]
		addwf	x0,1
		movlw	1
		btfsc	STATUS,C
		addwf	x1,1
		btfsc	STATUS,C
		addwf	x2,1
		btfsc	STATUS,C
		addwf	x3,1
		
		movf	y1,0				;add	x[1],y[1]
		addwf	x1,1
								
		movlw	1
		btfsc	STATUS,C
		addwf	x2,1
		btfsc	STATUS,C
		addwf	x3,1
		
		movf	y2,0				;add	x[2],y[2]	]
		addwf	x2,1
							
		movlw	1
		btfsc	STATUS,C
		addwf	x3,1

		movf	y3,0				;add	x[3],y[3]
		addwf	x3,1		
								
		return
;--------------------
;  ŕ@Z@step[24bit]=step[24bit]+ k[24bit] ;Bank1ŌvZ
add_step
	;bsf		STATUS,RP0
		movf	k0,0				;add	x[0],y[0]
		addwf	step0,1
		movlw	1
		btfsc	STATUS,C
		addwf	step1,1
		btfsc	STATUS,C
		addwf	step2,1
		
		movf	k1,0				;add	x[1],y[1]
		addwf	step1,1								
		movlw	1
		btfsc	STATUS,C
		addwf	step2,1
		
		movf	k2,0				;add	x[2],y[2]	]
		addwf	step2,1
		return
;---------------------------------------------------------------------
;	WrbgoCiPOiϊ
;	val0 Ɂ@Wqbgf[^uBival[3]:val[2]:val[1]:va[0])
;	dc8R[B
;
;	yɓi[B
;		(y[0]:y[1]:...:y[2])
;		y[0]ŏʌy[2]ŉʌłB
;	ϊval͔j󂳂B
dc8		movlw	y2		;	;mov	fsr,#dec_top		; i[ꏊl
		movwf	FSR
		incf	FSR,1
		call	devid_m			; ŉʕϊ 
		call	devid_m			;10JԂ
		call	devid_m		; ŏʕϊ
		
zblank
		movlw	D'2'		;**.*MHz\̑2܂blank\
		movwf	cn			;Zero Blanku

		movlw	y0		;movlw  dec0		;mov	fsr,#20h		; dec[0]i[ꏊl
		movwf	FSR
zb_1		movlw	B'00110000'
		subwf	INDF,0
		btfss	STATUS,Z		;if dec[]=00, then continue, else return
		return
zb_2			;if dec[]=00, then dec[]=0ehł́Ablank \ƂȂ
		movlw	H'20'	;Letter'_'
		movwf	INDF	;movwf	indirect

		incf	FSR,1
		decfsz	cn,1
		goto	zb_1
		return

;
;		POTu[`
;		POŏZ܂
;
devid_m		
		movlw	D'8'		;mov	cn,#32			; RQrbgԂ
		movwf	cn
		clrf		val_m
dev0		
		bcf		STATUS,C
		rlf		val0,1
		rlf		val_m,1
		
		movlw	B'11110110'
		addwf	val_m,0
		btfsc	STATUS,C
		movwf	val_m		;mov	val_m,w
		btfsc	STATUS,C
		incf	val0,1
		
		decfsz	cn,1		;djnz	cn,devide0
		goto	dev0
		decf	FSR,1
		movf	val_m,0		;mov	indirect,val_m		; ]
		xorlw	B'00110000'
		movwf	INDF
		return
;----------------------------------------end of 10iϊ
;
;---------------------------------------------------------------------
;	RQrbgoCiPOiϊ
;
;	valɂRQrbgf[^uBival[3]:val[2]:val[1]:va[0])
;
;	dcmainR[B
;
;	decɓi[B
;		(dec[0]:dec[1]:...:dec[8]:dec[9])
;		dec[0]ŏʌdec[9]ŉʌłB
;
;	ϊval͔j󂳂B
;
;	sample:
;		val	= 00:00:04:D2 h
;		dec	= 00:00:00:00:00:00:01:02:03:04
;                  dec(0):dec(1):(2):(3):(4):(5):(6):(7):(8):dec(9)
;						(1,234)
;
dcmain
		movlw	dec9		;	;mov	fsr,#dec_top		; i[ꏊl
		movwf	FSR
		incf	FSR,1
		call	devide			; ŉʕϊ 
		call	devide			;10JԂ
		call	devide
		call	devide
		call	devide

		call	devide
dcm1	call	devide
		call	devide
		call	devide
		call	devide			; ŏʕϊ
		
zeroblank
		movlw	D'5'		;**.*MHz\̑1܂blank\
		movwf	cn			;Zero Blanku

		movlw	dec0		;movlw  dec0		;mov	fsr,#20h		; dec[0]i[ꏊl
		movwf	FSR
zb1		movlw	B'00110000'
		subwf	INDF,0
		btfss	STATUS,Z		;if dec[]=00, then continue, else return
		return
zb2			;if dec[]=00, then dec[]=0ehł́Ablank \ƂȂ
		movlw	H'20'	;Letter'_'
		movwf	INDF	;movwf	indirect

		incf	FSR,1
		decfsz	cn,1
		goto	zb1
		return

;
;		POTu[`
;		POŏZ܂
;
devide		
		movlw	D'32'		;mov	cn,#32			; RQrbgԂ
		movwf	cn
		clrf		val_m
devide0		
		bcf		STATUS,C
		rlf		val0,1
		rlf		val1,1
		rlf		val2,1
		rlf		val3,1
		rlf		val_m,1
		
		movlw	B'11110110'
		addwf	val_m,0
		btfsc	STATUS,C
		movwf	val_m		;mov	val_m,w
		btfsc	STATUS,C
		incf	val0,1
		
		decfsz	cn,1		;djnz	cn,devide0
		goto	devide0
		decf	FSR,1
		movf	val_m,0		;mov	indirect,val_m		; ]
		xorlw	B'00110000'
		movwf	INDF
		return
;----------------------------------------end of 10iϊ
;-----------------------------------------------------------------------
;	|Z		x[32bit]=zz[24bit] * N[8bit]
;
;	zz 24rbgf[^uB  
;		i:zz[2]:zz[1]:zz[0]) 	vZߒ val_m g
;       N 8ޯްuB
;                 N ;  ő  #255łB
;
;	xɓi[B
;                ix[3]:x[2]:x[1]:x[0]) @@@@@
;       		
;	ϊ N ͔j󂳂ȂBzz2 `zz0 ACAj󂳂ȂB
;
;
mult_vN	clrf		x3
		clrf		x2
		clrf		x1
		clrf		x0
		clrf		val_m			;ǉ1
			
		movlw 	D'8'
		movwf 	cn
mult0	btfss	N,0
		goto	mutpas

		movf	zz0,0				;add	x[0],step[0]
		addwf	x0,1
		movlw	D'1'
		btfsc	STATUS,C
		addwf	x1,1
		btfsc	STATUS,C
		addwf	x2,1
		btfsc	STATUS,C
		addwf	x3,1

		movf	zz1,0				;add	x[1],step[1]
		addwf	x1,1									
		movlw	D'1'
		btfsc	STATUS,C
		addwf	x2,1
		btfsc	STATUS,C
		addwf	x3,1

		movf	zz2,0				;add	x[2],step[2]	
		addwf	x2,1
		movlw	D'1'
		btfsc	STATUS,C
		addwf	x3,1

		movf	val_m,0	
		addwf	x3,1				
									
mutpas	bcf		STATUS,C
		rlf		zz0,1
		rlf		zz1,1
		rlf		zz2,1
		rlf		val_m,1		;ǉ1
		btfsc	STATUS,C
		bsf		zz0,0

		bcf		STATUS,C
		rrf		N,1
		btfsc	STATUS,C
		bsf		N,7

		decfsz	cn,1			;	djnz	cn,mult0
		goto	mult0

		movlw	D'8'
		movwf	cn
multrot	bcf		STATUS,C
		rrf		val_m,1				;ǉ1
		rrf		zz2,1
		rrf		zz1,1
		rrf		zz0,1
	;	btfsc	STATUS,C
	;	bsf		zz3,7
		decfsz	cn,1			;djnz	cn,multrot
		goto 	multrot
		return
;---------------------------end of |Z


;-----------------------------------------------------
;	32rbgoCiZTu[`
;		val<32bit> = x<32bit> / y<16bit>; 
;
;	x 32 rbgf[^u܂B
;		ix[3]:x[2]:x[1]:x[0]) 
;       y 16ޯްu܂B
;              y[1]:y[0];  ő  H'FFFF'łB
;
;	val ɓi[܂B
;                ival[3]:val[2]:val[1]:val[0])  ]x[1][0]
;	vZ̉ߒ	Z		(32bit)(32bit)|y(32bit)gp
;       vZ̉ߒval[3]-val[0]Aval[0] ĝŒ`KvłB
;		
;
Div_xYY
		movf	y1,0		;y=y *256*256
		movwf	y3
		movf	y0,0
		movwf	y2
		clrf	y1
		clrf	y0
		movlw	D'17'			
		movwf	cn
		movlw	D'16'			
		movwf	cs
		clrf	val0
		clrf	val1
		clrf	val2
		clrf	val3

Dv1		movf	cs,1
		btfsc	STATUS,Z	;if y=0, can't divided then return
		return	
		btfsc	y3,7	;if y3.7 =0, then y rotate
		goto	Dv2
		bcf		STATUS,C
		rlf		y2,1
		rlf		y3,1
		incf	cn,1
		decfsz	cs,1
		goto 	Dv1		
				
Dv2		;;x>=y ? check
		movf	x3,0
		subwf	y3,0		; W=y3+ (256-x3)
		btfss	STATUS,C	; if y3<x3, then Dv3
		goto	Dv3
		btfss	STATUS,Z	; if y3>x3, then Dv4
		goto	Dv4

		movf	x2,0
		subwf	y2,0		; W=y2+ (256-x2)
		btfss	STATUS,C	; if y2<x2, then Dv3
		goto	Dv3
		btfss	STATUS,Z	; if y2>x2, then Dv4
		goto	Dv4

		movf	x1,0
		subwf	y1,0		; W=y1+ (256-x1)
		btfss	STATUS,C	; if y1<x1, then Dv3
		goto	Dv3
		btfss	STATUS,Z	; if y1>x1, then Dv4
		goto	Dv4

		movf	x0,0
		subwf	y0,0		; W=y0+ (256-x0)
		btfss	STATUS,C	; if y0<x0, then Dv3
		goto	Dv3
		btfss	STATUS,Z	; if y0>x0, then Dv4
		goto	Dv4
		goto	Dv3

Dv3		;x>=y@Ȃ̂ňZ
		call 	sub_xy	;(32bit)(32bit)|y(32bit)
		bsf		STATUS,C	
		goto	Dv5

Dv4		;x<y Ȃ̂ 
		bcf		STATUS,C	
Dv5		rlf		val0,1
		rlf		val1,1
		rlf		val2,1
		rlf		val3,1	
		decfsz	cn,1		
		goto	Dv6
		return
Dv6		bcf		STATUS,C
		rrf		y3,1	
		rrf		y2,1
		rrf		y1,1	
		rrf		y0,1
		goto	Dv2
	;;;;;;;;;;;;;;;;End of Div_xYY ;;;;;;;;;;;;; 
;------
;---------


;========== MSx_P1 & MSNx_P2 & MSNx_P3set@to Register42-49==============
MSx1	bsf		STATUS,RP0	;bank1  1@//̌vZ
	;=========== Every time Fixed ===================
		;MSx_P1[17:0]= 128 x(dd x2) + Floor (128 x (e/f))-512	 //, e=0, f=1
		;;MSx_P1=128 x (dd x2) -512// 512=H'2 00'
		;//MSx_P2=0//MSx_P3=1
	;===========
	;@1/4@̂ƂA@AN619 P.6 ŁB
		;if 150MHz<Fout<=200MHz, MSx_P1=0, MSx_P2=0, , MSx_P3=1,  
		;, MSx_INT=1(Reg.16-21 bit6),and MSx_DIVBY4[1:0]=11b
		movlw	D'2'		;if divided by 4(dd=2), MSx_P1, P2=0 and P3=1, 
		subwf	dd,0
		btfss	STATUS,Z
		goto	Msx_5
		clrf	P1x_0
		clrf	P1x_1
		clrf	P1x_2
		clrf	P2x_0
		clrf	P2x_1
		clrf	P2x_2

		movlw	H'01'
		movwf	P3x_0		;P1x = 128 x d
		clrf	P3x_1
		clrf	P3x_2
		goto	Msx_end		

Msx_5	clrf	P1x_0	
		movf	dd,0
		movwf	P1x_1		;P1x = 128 x d@	//d(ۂ2xd)Ȃ̂ŁAP1x_1֓邾ŁA128xdZB
		clrf	P1x_2

		movlw	H'02'		;P1x = 128 x d -512//	512=H'2 00'	
		subwf	P1x_1,1
		movlw	1
		btfss	STATUS,C
		subwf	P1x_2,1

			;MSx_P2[19:0]= 128 x e - f x Floor (128 x (e/f))	 //d=8, e=0, f=1
Msx_7	clrf	P2x_0		;
		clrf	P2x_1
		clrf	P2x_2

			;MSx_P3[19:0]= f	 //d=8, e=0, f=1
		movlw	H'FF'
		movwf	P3x_0		;
		clrf	P3x_1
		clrf	P3x_2
	bcf		STATUS,RP0	;bank0
Msx_end	return

;========== Registe 42,43,44,45,46,47,48,49̏========
		;MSx_P1[17:0]= 128 xdd + Floor (128 x (e/f))-512	 //, e=0, f=1
	;@1/4@̂ƂA@AN619 P.6 ŁB
		;if 150MHz<Fout<=200MHz, MSx_P1=0, MSx_P2=0, , MSx_P3=1,  
		;, MSx_INT=1(Reg.16-21 bit6),and MSx_DIVBY4[1:0]=11b(Reg.44)
;========== {vOł́A4=< dd =<510@EETableĺAdd x1/2 ŕ\i8bit dataƂ邽߁j
MSx1_Reg
	bsf		STATUS,RP0	;bank1
	;=========== test ==============; MSx_Px̉ltest̊Jn---	
	;	movlw	H'FF'	;;  DebagpƂĎcĂ
	;	movwf	P3x_0	;Always =H'FF'	 
	;	clrf	P3x_1		
	;	clrf	P3x_2		
	;=========== test ===================
	;	movlw	H'00'	;;P1N[17:0]= H'0 16 00'	;Band7; 10.5MHz d=48
	;	movwf	P1x_0	;P1N=128 x48 -512 =	H'16 00' 
	;	movlw	H'16'
	;	movwf	P1x_1		
	;	movlw	H'00'
	;	movwf	P1x_2		
	;=========== test ===================
	;	clrf	P2x_0	;;;Always =0		 
	;	clrf	P2x_1		
	;	clrf	P2x_2		
	;============ test    ==================; MSNA_Px̉ltest̏I----

	bsf		STATUS,RP0	;bank1		
		movlw	D'42'	;Register 42 and 43,44,45,46,47,48,49//Fixed
		movwf	Regnum
		call	Si53_regi	;uI_start  I_adres@ˁ@I_ack@	I_register@data	@ˁ@I_ackv	

		movf	P3x_1,0	; Reg42//Fixed P3x_1=0
		movwf	dat_Si
		call	Si53_data	;uI_data	@ˁ@I_ackv

		movf	P3x_0,0		; Reg43//Fixed P3x_0=H'01'
		movwf	dat_Si
		call	Si53_data

			;̊ԁ@@1/4@̂ƂA@AN619 P.6 Ꮘu@and P.34 for Register44
		movlw	D'2'
		subwf	dd,0	;if divided by 4(dd=2), bit[3:2]=[11] ,else [00]
		movlw	B'00000000'
		btfsc	STATUS,Z
		movlw	B'00001100'
		xorwf	P1x_2,0
			;ᏈȕI	; Reg44
		movwf	dat_Si
		call	Si53_data

		movf	P1x_1,0		; Reg45
		movwf	dat_Si
		call	Si53_data

		movf	P1x_0,0		; Reg46
		movwf	dat_Si
		call	Si53_data

		swapf	P3x_2,0		;P3x_2[19:16]
	;	andlw	B'11110000'
		xorwf	P2x_2,0		; Reg47//Fixed  P3x_2[19:16] + P2x_2=0[19:16]
		movwf	dat_Si
		call	Si53_data

		movf	P2x_1,0		; Reg48//Fixed P2x_1=0
		movwf	dat_Si
		call	Si53_data

		movf	P2x_0,0		; Reg49//Fixed P2x_0=0
		movwf	dat_Si
		call	Si53_data
		call	I_stop		;Stop
	bcf		STATUS,RP0	;bank0
		return
;;========== uMSx_P1 & MSNx_P2 & MSNx_P3setvEnd==============

;prg order [call	MSN3Cal][call	MSN1Cal][call	MSN2Cal][call	MSNset]
;=========Cal.P3N[19:0]=  c =250,000	=H'3 d0 90'	  ====================

MSN3Cal bsf		STATUS,RP0	;bank1
	;=========== Every time Fixed===================	
		movlw	H'90'	;;P3N[19:0]=  c =250,000	=H'3 d0 90'	
		movwf	P3N_0		 
		movlw	H'd0'
		movwf	P3N_1		
		movlw	H'03'
		movwf	P3N_2		
	;==============================	;----
		bcf		STATUS,RP0	;bank0
		return
;=========uCal.P3N[19:0]=  c=250,000	=H'3 d0 90'	 vEnd  ====================

;=========Cal.P1N= 128x a +Floor( 128x (b/c))-512 ̌vZ  =========================	
MSN1Cal bsf		STATUS,RP0	;bank1  /390cycle
		;P1N[17:0]= 128 x a +Floor(128x (b/c)) -512
		;P2N[19:0]= 128 x b - c xFloor(128x (b/c))
		;P3N[19:0]=  c =250,000	=H'3 d0 90'						

;----FbcFloor( 128x (b/c))= Floor (b x128/250,000)@̌vZ
FC1		clrf	k0
		movf	b0,0	;k= b x256 
		movwf	k1
		movf	b1,0
		movwf	k2
		movf	b2,0
		movwf	k3		;̌vZŁ@1bit̂ŁAʁ@k= b x128 ƂȂ

		movlw	D'8'
		movwf	scn
FC2		movlw	H'03'	;;250,000 = H'03 d0 90'
		subwf	k3,0	;W = k3 +(256- 03)	
		btfss	STATUS,C
		goto	FC6
		btfss	STATUS,Z 
		goto	FC7

		movlw	H'd0'
		subwf	k2,0	;W = k2 +(256- 0xd0)	
		btfss	STATUS,C
		goto	FC6
		btfss	STATUS,Z 
		goto	FC7

		movlw	H'90'
		subwf	k1,0	;W = k1 +(256- 0x90)	
		btfss	STATUS,C
		goto	FC6
		goto	FC7
	
FC6		bcf		STATUS,C
		rlf		Fbc,1
		goto	FC8

FC7		bsf		STATUS,C
		rlf		Fbc,1
		call	sub_kk		;k =k(32bit) -  H'03 d0 90' /16cycle
		goto	FC8

FC8		bcf		STATUS,C
		rlf		k0,1	;k = k x2
		rlf		k1,1
		rlf		k2,1
		rlf		k3,1
		decfsz	scn,1
		goto	FC2	
		goto	MSN1	;FbcvZ
			; 
MSN1	bsf		STATUS,RP0	;bank1	;[(128x b)c - b ] Z@End
	;	;P1N[17:0]= 128 x a +Floor(128x (b/c)) -512 ̌vZ
		;------ 128 x a 
		clrf	P1N_0
		clrf	P1N_2
		movf	aa,0
		movwf	P1N_1	;P1N=256 x a

		bcf		STATUS,C
		rrf		P1N_1,1		;P1N = 128 x a
		rrf		P1N_0,1
	
		movf	Fbc,0		;Fbc = Floor(128x (b/c)
		addwf	P1N_0,1		;P1N = 128 x a + Fbc
		movlw	1
		btfsc	STATUS,C
		addwf	P1N_1,1	
		btfsc	STATUS,C
		addwf	P1N_2,1	

		movlw	H'02'	;H'02' = D'512'
		subwf	P1N_1,1	;P1N= 128 x a +  Floor(128x (b/c) -512
		movlw	1
		btfss	STATUS,C
		subwf	P1N_2,1		
		bcf		STATUS,RP0	;bank0
		return
	;---------
;	Z		(32bit)(32bit)|y(32bit)@
sub_kk		;k =k(32bit) -  H'03 d0 90' /16cycle
		movlw	H'90'				;sub	x[1],y[1];
		subwf	k1,1
		movlw	1
		btfss	STATUS,C
		subwf	k2,1
		btfss	STATUS,C
		subwf	k3,1

		movlw	H'd0'				;sub	x[2],y[2];
		subwf	k2,1		
		movlw	1
		btfss	STATUS,C
		subwf	k3,1

		movlw	H'03'				;sub	x[3],y[3]
		subwf	k3,1								
		return

;=========uCal.P1N= 128 xa@ +Floor(128x (b/c))= Floor (b x 128/250,000) vEnd =========================

;=========Cal.P2N[19:0]= 128 x b - c xFloor(128x (b/c)) =========================	
;-----------------------
MSN2Cal bsf		STATUS,RP0	;bank1	/300cycle
		;	;P2N[19:0]= 128 x b - c xFloor(128x (b/c))
		;c=250,000=H'3 d0 90' ,  Floor(128x (b/c)=Fbc
		;----P2N= 256 xb
		movf	Fbc,0
		movwf	Fbc1	
		clrf	P2N_0
		movf	b0,0
		movwf	P2N_1		;P2N=256 x b 
		movf	b1,0
		movwf	P2N_2		;P2N=256 x b 
		movf	b2,0
		movwf	P2N_3		;P2N=256 x b 	;⏕P2N_3@ vZp				
		;---- 
		bcf		STATUS,C	;
		rrf		P2N_3,1
		rrf		P2N_2,1		;P2N= b x 128
		rrf		P2N_1,1		;P2N= b x 128
		rrf		P2N_0,1		;P2N= 128 x b
	;--------
	;--------  P2N= 128 x b - c xFloor(128x (b/c)) // Fbc1= Floor(128x (b/c)
		movlw	H'90'	;;  c ==250,000=H'03 d0 90'
		movwf	val0		;Val= H'03 d0 90'
		movlw	H'd0'
		movwf	val1		;
		movlw	H'03'
		movwf	val2

		bcf		STATUS,C
		rrf		Fbc1,1	;0bit of Floor(128x (b/c)=Fbc //0
		btfsc	STATUS,C
		call	sub_P2val		;	P2N(32bit)P2N(32bit)|val(32bit)@
		nop
				;++++
		call	Rot_val		;Val = Val x 2^1
		bcf		STATUS,C
		rrf		Fbc1,1	;1bit of Floor(128x (b/c)=Fbc //0
		btfsc	STATUS,C
		call	sub_P2val		;	P2N(24bit)P2N(24bit)|val(24bit)@
		nop		
				;++++
		call	Rot_val		;Val = Val x 2^2
		bcf		STATUS,C
		rrf		Fbc1,1	;2bit of Floor(128x (b/c)=Fbc  //1
		btfsc	STATUS,C
		call	sub_P2val		;	P2N(24bit)P2N(24bit)|val(24bit)@
		nop		
				;++++
		call	Rot_val		;Val = Val x 2^3
		bcf		STATUS,C
		rrf		Fbc1,1	;3bit of Floor(128x (b/c)=Fbc  //0
		btfsc	STATUS,C
		call	sub_P2val		;	P2N(24bit)P2N(24bit)|val(24bit)@
		nop		
				;++++
		call	Rot_val		;Val = Val x 2^4
		bcf		STATUS,C
		rrf		Fbc1,1	;4bit of Floor(128x (b/c)=Fbc  //1
		btfsc	STATUS,C
		call	sub_P2val		;	P2N(24bit)P2N(24bit)|val(24bit)@
		nop	
				;++++
		call	Rot_val		;Val = Val x 2^5
		bcf		STATUS,C
		rrf		Fbc1,1	;5bit of Floor(128x (b/c)=Fbc  //0
		btfsc	STATUS,C
		call	sub_P2val		;	P2N(24bit)P2N(24bit)|val(24bit)@
		nop		
				;++++
		call	Rot_val		;Val = Val x 2^6
		bcf		STATUS,C
		rrf		Fbc1,1	;6bit of Floor(128x (b/c)=Fbc  //0
		btfsc	STATUS,C
		call	sub_P2val		;	P2N(24bit)P2N(24bit)|val(24bit)@
		nop		
				;++++
		call	Rot_val		;Val = Val x 2^7
		bcf		STATUS,C
		rrf		Fbc1,1	;7bit of Floor(128x (b/c)=Fbc  //1
		btfsc	STATUS,C
		call	sub_P2val		;	P2N(24bit)P2N(24bit)|val(24bit)@
		nop				;result	;P2N[19:0]= 128 x b - c xFloor(128x (b/c))	

		bcf		STATUS,RP0		;bank0
		return

sub_P2val		;	Z		P2N(32bit)P2N(32bit)|val(24bit)@
		movf	val0,0				;sub	x[0],y[0]
		subwf	P2N_0,1
		movlw	1
		btfss	STATUS,C
		subwf	P2N_1,1
		btfss	STATUS,C
		subwf	P2N_2,1
		btfss	STATUS,C
		subwf	P2N_3,1

		movf	val1,0				;sub	x[1],y[1];
		subwf	P2N_1,1
		movlw	1
		btfss	STATUS,C
		subwf	P2N_2,1
		btfss	STATUS,C
		subwf	P2N_3,1

		movf	val2,0				;sub	x[2],y[2];
		subwf	P2N_2,1	
		movlw	1
		btfss	STATUS,C
		subwf	P2N_3,1
		return

		; val (=C) Rotate
Rot_val		; val (=C) Rotate	
		bcf		STATUS,C		;Val = Val x 1/2^3
		rlf		val0,1
		rlf		val1,1
		rlf		val2,1
		return
;=================uCal.P2N[19:0]= 128 x b - c xFloor(128x (b/c)) v End	=================



;--- Si5351a Registerɏ ---
;WWX^ɃR}hZbg
Si53_load	;uI_start  I_adres@ˁ@I_ack@	I_register data	@ˁ@I_ack ˁ@I_data@ˁ@I_ack@ I_stopv	
;	bcf		STATUS,RP0 ;Bank0	
;	MOVWF	dat_Si	;
	call	I_start	;Start condition //startaddressacknowlege
;	call	I_adres		;Slave adresss
;	call	I_ack		;Acknowledge confirm
	movf	Regnum,0		;Register address byte
	call	I_data		;Data	//data acknowlege
;	call	I_ack		;Acknowledge confirm
	movf	dat_Si,0		;	Data
	call	I_data		;Data	//data acknowlege
;	call	I_ack		;Acknowledge confirm
	call	I_stop		;Stop	
	return

;--- Si5351a
Si53_regi	;uI_start  I_adres@ˁ@I_ack@	I_register@data	@ˁ@I_ackv	
;	bcf		STATUS,RP0 ;Bank0	
	call	I_start	;Start condition	//startaddressacknowlege
;	call	I_adres		;Slave adresss
;	call	I_ack		;Acknowledge confirm
	movf	Regnum,0		;Register address byte
	call	I_data		;Data	//data acknowlege
;	call	I_ack		;Acknowledge confirm
	return

Si53_data	;uI_data	@ˁ@I_ackv	
;	bcf		STATUS,RP0 ;Bank0
	movf	dat_Si,0		;	Data
	call	I_data		;Data	//data acknowlege
;	call	I_ack		;Acknowledge confirm
;	call	I_stop		;Stop	
	return

;---------------------
;I2C Tu[`
;---------------------
;------ȉ@I2C ̃Tu[`----------
I_start	bcf		PIR1,SSPIF	;bit3=SSPIF=0=Bit cleared@//startaddressacknowlege

		bsf		STATUS,RP0 ;Bank1
		bsf		SSPCON2,SEN	;bit0=1=StartCondition SDA &SCL,
	bcf		STATUS,RP0 ;Bank0
		btfss	PIR1,SSPIF	;bit3=SSPIF=1=The initiated Start condition was completed
		goto	$-1
		bcf		PIR1,SSPIF
;	bsf		STATUS,RP0 ;Bank1
	;	return

I_adres	bcf		STATUS,RP0 ;Bank0  //addressacknowlegeacknowlege
		bcf		PIR1,SSPIF	;bit3=SSPIF clear. Start/Stop conditon
		movlw	H'C0'		;Slave Address	AQM;3E+0=H'7C'	Si5351;H'60'+0=H'C0'
		movwf	SSPBUF 		;mov Slave Address	
		btfss	PIR1,SSPIF	;bit3=SSPIF=1=The initiated Start condition was completed
		goto	$-1
		bcf		PIR1,SSPIF
I_ack	bsf		STATUS,RP0 ;Bank1		//	acknowlege
		btfsc	SSPSTAT,BF		;bit0=BF=0=Data transmit complete, 
		goto	$-1
		
		btfss	SSPCON2,ACKSTAT	;bit6=ACKSTAT=0 = Acknowledge was received from slave
		return
	;	call	LED 	;;;;;;;;;;;acknowledge error @RC1LED_;;;;;;;;;;
	;	return
	;	goto	$-2		
		
I_data	bcf		STATUS,RP0 ;Bank0	//data @acknowlege
		bcf		PIR1,SSPIF	;bit3=SSPIF clear. Start/Stop conditon
	;	bcf		STATUS,RP0 ;Bank0
	;	movf	dat_Si,0		;W@register Data
		movwf	SSPBUF 		;mov Data
	
		btfss	PIR1,SSPIF	;bit3=SSPIF=1=The initiated Start condition was completed
		goto	$-1
		bcf		PIR1,SSPIF
		goto	I_ack
;	bsf		STATUS,RP0 ;Bank1
;	return			
	
I_stop	bcf		STATUS,RP0 ;Bank0
		bcf		PIR1,SSPIF	;bit3=SSPIF clear. Start/Stop conditon

	bsf		STATUS,RP0 ;Bank1
		bsf		SSPCON2,PEN	;bit2=PEN=1=StopCondition SDA &SCL,
		bcf		STATUS,RP0 ;Bank0
		btfss	PIR1,SSPIF	;bit3=SSPIF=1=The initiated Start condition was completed
		goto	$-1
		bcf		PIR1,SSPIF
		return	

			;TEST------------
LED		nop	
		bsf		PORTC,1
		call	wt250ms
	;	bcf		PORTC,1
		call	wt250ms
	;	bsf		PORTC,1
	;	call	wt250ms
	;	bcf		PORTC,1
		return	
LEDOff	bcf		PORTC,1
		return
	;	goto	st10	;LED TEst


	ORG 0x800

B_data	bsf  	STATUS,RP0	;oN1
		bcf		STATUS,RP1	;oN1
		movf	N2_bnd,0
		addwf	PCL,1  	;		;W=Nbanmd// 0=< Nband@<=8
		goto	B_0	;Nband=0
		goto	B_1 	;Nband=1
		goto	B_2 	;Nband=2
		goto	B_3 	;Nband=3
		goto	B_4 	;Nband=4
		goto	B_5 	;Nband=5
		goto	B_6  	;Nband=6
		goto	B_7 	;Nband=7  
		goto	B_8 	;Nband=8
		goto	B_9 	;Nband=9
		goto	B_10  	;Nband=10
		goto	B_11 	;Nband=11  
		goto	B_12	;Nband=12
		goto	B_13 	;Nband=13
		goto	B_14 	;Nband=14


	;܂Ł@H'0FF'255ȓ
	;========	

B_0 	nop  	;Nband=0	;1.0MHz; b=100,000=H'01 86 A0'// a=20=H'14' //d=255 (ۂ510)
		movlw	H'A0'	; 	;
		movwf	b0		;
		movlw	H'86'	;
		movwf	b1
		movlw	H'01'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'255'
		movwf	dd
		movlw	D'4'	;if D'4', then bbZ@4JԂ// cn_bb= 4, 2, 1 only
		movwf	cn_bb
		return

B_1 	nop  	;Nband=1	;1.35MHz; b=184,000=H'02 CE C0'// a=20=H'14'//d=192 (ۂ384)
		movlw	H'C0'	; 	;
		movwf	b0		;
		movlw	H'CE'	;
		movwf	b1
		movlw	H'02'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'192'
		movwf	dd
		movlw	D'2'	;if D'2', then bbZ@2JԂ
		movwf	cn_bb
		return

B_2 	nop  	;Nband=2	;2.0MHz; b=120,000=H'01 D4 C0'// a=20=H'14'//d=128 (ۂ256)
		movlw	H'C0'	; 	;
		movwf	b0		;
		movlw	H'D4'	;
		movwf	b1
		movlw	H'01'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'128'
		movwf	dd
		movlw	D'2'	;if D'2', then bbZ@2JԂ
		movwf	cn_bb
		return

B_3 	nop  	;Nband=3	;2.7MHz;7 b=184,000=H'02 CE C0'// a=20=H'14'//d=81 (ۂ192)
		movlw	H'C0'	; 	;
		movwf	b0		;
		movlw	H'CE'	;
		movwf	b1
		movlw	H'02'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'96'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return

B_4 	nop  	;Nband=4	;4.0MHz; b=120,000=H'01 D4 C0'// a=20=H'14'//d=64 (ۂ128)
		movlw	H'C0'	; 	;
		movwf	b0		;
		movlw	H'D4'	;
		movwf	b1
		movlw	H'01'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'64'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return

B_5 	nop  	;Nband=5	;5.4MHz; b=184,000=H'02 CE C0'// a=20=H'14'//d=48 (ۂ96)
		movlw	H'C0'	; 	;
		movwf	b0		;
		movlw	H'CE'	;
		movwf	b1
		movlw	H'02'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'48'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return

B_6 	nop  	;Nband=6	;8.0MHz; b=120,000=H'01 D4 C0'// a=20=H'14'//d=32 (ۂ64)
		movlw	H'C0'	; 	;
		movwf	b0		;
		movlw	H'D4'	;
		movwf	b1
		movlw	H'01'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'32'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return

B_7 	nop  	;Nband=7	;10.5MHz b=40,000=H'00 9C 40'// a=20=H'14'//d=24 (ۂ48)
		movlw	H'40'	; 	;
		movwf	b0		;
		movlw	H'9C'	;
		movwf	b1
		movlw	H'00'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'24'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return

B_8 	nop  	;Nband=8	;16.0MHz; b=120,000=H'01 D4 C0'// a=20=H'14'//d=16 (ۂ32)
		movlw	H'C0'	; 	;
		movwf	b0		;
		movlw	H'D4'	;
		movwf	b1
		movlw	H'01'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'16'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return

B_9 	nop  	;Nband=9	;21.0MHz; b=40,000=H'00 9C 40'// a=20=H'14'//d=12 (ۂ24)
		movlw	H'40'	; 	;
		movwf	b0		;
		movlw	H'9C'	;
		movwf	b1
		movlw	H'00'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'12'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return

B_10 	nop  	;Nband=10	;32.0MHz; b=120,000=H'01 D4 C0'// a=20=H'14'//d=8 (ۂ16)
		movlw	H'C0'	; 	;
		movwf	b0		;
		movlw	H'D4'	;
		movwf	b1
		movlw	H'01'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'8'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return

B_11 	nop  	;Nband=11	;42.0MHz; b=40,000=H'00 9C 40'// a=20=H'14'//d=6 (ۂ12)
		movlw	H'40'	; 	;
		movwf	b0		;
		movlw	H'9C'	;
		movwf	b1
		movlw	H'00'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'6'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return

B_12 	nop  	;Nband=12	;63.0MHz; b=40,000=H'00 9C 40'// a=20=H'14'//d=4 (ۂ8)
		movlw	H'40'	; 	;
		movwf	b0		;
		movlw	H'9C'	;
		movwf	b1
		movlw	H'00'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'4'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return

B_13 	nop  	;Nband=13	;85.0MHz; b=100,000=H'01 86 A0'// a=20=H'14'//d=3 (ۂ6)
		movlw	H'A0'	; 	;
		movwf	b0		;
		movlw	H'86'	;
		movwf	b1
		movlw	H'01'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'3'		;	D'3'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return

B_14 	nop  	;Nband=14	;130.0MHz; b=200,000=H'03 0D 40'// a=20=H'14'//d=2 (ۂ4)
		movlw	H'40'	; 	;
		movwf	b0		;
		movlw	H'0D'	;
		movwf	b1
		movlw	H'03'	;
		movwf	b2
		movlw	D'20'
		movwf	aa
		movlw	D'2'
		movwf	dd
		movlw	D'1'	;
		movwf	cn_bb
		return
;==========================
;----------------- IF setting l@vO---------
IF_start	;	;call	readb
		bcf		INTCON,GIE	;荞݋֎~		
	bsf		STATUS,RP0	;oN1	;rb.2-7s input mode
		movlw	B'11111111'	;rb.0-7sin  !rb,#11111111b
		movwf	TRISB		;trisb
	bcf		STATUS,RP0	;oN0
IFs_1	nop
		btfss	PORTB,1
		goto	IFs_1

	bcf		PCLATH,3	;̈GPage0 ֖߂	
		call	load_IF
	bsf		PCLATH,3	;̈GPage1 	

	bcf		PCLATH,3	;̈GPage0 ւ̐ؑ
	;	call	LED
	bsf		PCLATH,3	;̈GPage1 	
		movlw	0	
		movwf	N_step
		call	Istp_st

		movf	PORTB,0	
		andlw	B'00110000'	;RB4, 5̂ݎc
		movwf	new45
		movwf	old45
	;	movlw	B'00001000'			;GIE=0 disable, INTE(RB4-7 Port Change)=1 enable
	;	movwf	INTCON	; 

		clrf	vfc
		bsf		vfc,0	

IFmain	;bsf		INTCON,7	;荞݊Jn
		call	Bread	;====RB0`RB1̕ω============
		movf	PORTB,0			;Rb0-3̕ω`FbN
		andlw	B'00001111'
		movwf	Rb30 	;Rb3-0 ̕ۑWX^
		sublw	B'00001111' 	;
     	btfss	STATUS,Z		;if PORTB=B'xxxx1111' ,then skip  
		goto	RB01ck

		call	AdjIF

IFm2	btfss	vfc,0	
		goto	IFmain

IFm3	bcf		INTCON,GIE	;荞݋֎~
		clrf	vfc
		call	Cal_IF

	bcf		PCLATH,3	;̈GPage0 ֖߂	
		call	dp_Fre	;	;LCDg@1s5`16@12\
	bsf		PCLATH,3	;̈GPage1 		
		btfss	IFset,7
		goto	IFmain

IFm7	movlw	H'20'
		movwf	dec1	;[_]
		movwf	dec2	;[_]
			;	[,]
		movlw	H'20'
		movwf	dec3
		movlw	H'37'
		movwf	dec4	;[7]
		movlw	H'33'
		movwf	dec5	;[3]
			;	[,]
		movlw	H'26'
		movwf	dec6	;[&]
		movlw	H'38'
		movwf	dec7	;[8]
		movwf	dec8	;[8]
			;	[,]
		movlw	H'20'
		movwf	dec9	;[_]

	bcf		PCLATH,3	;̈GPage0 ֖߂
		call	dp_Fre	;
	bsf		PCLATH,3	;̈GPage1 

IFmn10	nop
		goto 	IFmn10
;----------------------
AdjIF	
Adj1	call	Bread		;input mode portb
Adj2	movf	PORTB,0	
		andlw	B'00110000'	;RB4, 5̂ݎc
		movwf	new45

Adj5	btfss	old45,4		;if old01.4= HL,then next step, else goto Adj2(Adj_e)
		goto 	Adj_e
		btfsc	new45,4
		goto 	Adj_e
		goto	encd1

encd1	btfss	new45,5	;Rb5=LȂ Ifre Zadd
		goto	sub_Is	;Sub	Ifre=Ifre-step
		goto	add_Is	;Add	Ifre=Ifre+step

Adj_e	movf	new45,0		;old45=new45
		movwf	old45
		return

;-----------------------
Bread	bsf		STATUS,RP0	;oN1	;rb.2-7s input mode
		movlw	B'11111111'	;rb.0-7sin  !rb,#11111111b
		movwf	TRISB		;trisb
	bcf		STATUS,RP0	;oN0
		clrf	PORTB
		return
;-----------------------
Cal_IF	movf	Ifre0,0
		movwf	val0
		movf	Ifre1,0
		movwf	val1
		movf	Ifre2,0
		movwf	val2
		clrf	val3
	bcf		PCLATH,3	;̈GPage0 ֖߂
		call 	dcmain
	bsf		PCLATH,3	;̈GPage1 
		return

;-----------------------
;	Check for STEP, during IF set
RB01ck	bcf		INTCON,GIE
		call	Bread	;input mode portb
RB01_1	;call	wt4ms	;prevent chattering	
		movf	PORTB,0
		andlw	B'00001111'
		sublw	B'00001111'
		btfss	STATUS,Z
		goto	RB01_1

		btfss	Rb30,0
		goto	Istp_chg

		btfsc	Rb30,1		;RB1 SWꂽAIF@EEPROM@Save
		goto	IFm2
	bcf		PCLATH,3	;̈GPage0 ֖߂
		call	sav_IF
	bsf		PCLATH,3	;̈GPage1 		
RB01_5	nop
		bsf		IFset,7
		goto	IFm7
;------------
Istp_chg		;;N_step =0(100Hz), 1(10kHz) ,2(100kHz), 
		incf	N_step,1	;N_step= N_step+1 (0<= Nband <=3)
		movf	N_step,0
		sublw	D'3'		;W=3 +(256- N_step)
		movlw	D'0'	
		btfss	STATUS,Z
		movf	N_step,0
		movwf	N_step
		call	Istp_st
		goto	IFm2
	;-----------
Istp_st	movlw	0	
		subwf	N_step,0
		btfsc	STATUS,Z 	;if N_step =0 ,then goto st100	
		goto	Ist100

		movlw	1	
		subwf	N_step,0
		btfsc	STATUS,Z 	;if N_step =0 ,then goto st10k	
		goto	Ist10k

		movlw	2	
		subwf	N_step,0
		btfsc	STATUS,Z 	;if N_step =1 ,then goto st100k	
		goto	Ist100k	
		return	

Ist100	bsf		STATUS,RP0	;bank1
		movlw	D'1'		;100Hz(step=1)
		movwf	step0
		clrf	step1

	bcf		STATUS,RP0	;bank0
		movlw	H'30'	;u0v
		movwf	dsp1
		movlw	H'2e'	;u.v
		movwf	dsp2
		movlw	H'31'	;u100Hv
		movwf	dsp3
		movlw	H'6B'	;ukv
		movwf	dsp4
		goto	Ist_e

Ist10k	bsf		STATUS,RP0	;bank1
		movlw	D'100'		;10kHz(step=100)
		movwf	step0
		clrf	step1

	bcf		STATUS,RP0	;bank0
		movlw	H'20'	;u_v
		movwf	dsp1
		movlw	H'31'	;u1v
		movwf	dsp2
		movlw	H'30'	;u0v
		movwf	dsp3
		movlw	H'6B'	;ukv
		movwf	dsp4
		goto	Ist_e

Ist100k	bsf		STATUS,RP0	;bank1
		movlw	H'e8'		;100kHz(step=1000)
		movwf	step0
		movlw	H'03'
		movwf	step1

	bcf		STATUS,RP0	;bank0
		movlw	H'31'	;u1v
		movwf	dsp1
		movlw	H'30'	;u0v
		movwf	dsp2
		movlw	H'30'	;u100Hv
		movwf	dsp3
		movlw	H'6B'	;ukv
		movwf	dsp4
		goto	Ist_e

Ist_e	bcf		PCLATH,3	;̈GPage0 ֖߂
		call	dp_st
	bsf		PCLATH,3	;̈GPage1 
		return		
;-----------------------
;	Z		Ifre(24bit)Ifre(24bit)|step(16bit)@
sub_Is	bsf		STATUS,RP0	;bank1
		movf	step0,0				;sub	x[0],y[0]
	bcf		STATUS,RP0	;bank0
		subwf	Ifre0,1
		movlw	1
		btfss	STATUS,C
		subwf	Ifre1,1
		btfss	STATUS,C
		subwf	Ifre2,1

	bsf		STATUS,RP0	;bank1
		movf	step1,0				;sub	x[1],y[1];
	bcf		STATUS,RP0	;bank0
		subwf	Ifre1,1
		movlw	1
		btfss	STATUS,C
		subwf	Ifre2,1
		bsf		vfc,0
		goto	Adj_e
;--------------------------------------------------------------------
; 	Z	Ifre(24bit)Ifre(24bit){step(16bit)@
add_Is	bsf		STATUS,RP0	;bank1			
		movf	step0,0				;add	x[0],y[0]
	bcf		STATUS,RP0	;bank0
		addwf	Ifre0,1
		movlw	1
		btfsc	STATUS,C
		addwf	Ifre1,1
		btfsc	STATUS,C
		addwf	Ifre2,1

	bsf		STATUS,RP0	;bank1		
		movf	step1,0				;add	x[1],y[1]
	bcf		STATUS,RP0	;bank0
		addwf	Ifre1,1
		movlw	1
		btfsc	STATUS,C
		addwf	Ifre2,1
		bsf		vfc,0		
		goto	Adj_e
;--------------------
	
; example of preloading EEPROM locations

	ORG	0x2100
	DE	H'FF', 4, 3, 2, 1
;	DE	  H'01',H'0C',H'C0',H'4B',H'03',H'1C',H'04', H'01',   H'0', H'C0',H'D4',H'01' 
    ;      ROM1,N_bnd,  b0,   b1,    b2,   aa,   dd, cn_bb,N2_step,Ifre0,Ifre1,Ifre2
;̗ł́ABand=12, PLL=25Mx (aa+(b/250,000)) =25x(28+ (216,000/250,000)@=721.6MHz @
		;=2xdd= 2x04=8  VCO=721.6/8=90.2MHz `IF=H'01 D4 C0'= 12.000.0MH
	END                       ; directive 'end of program'

